import java.io.*;

class NativeWrite {

    //private FileInputStream fis;
    public int fd;
    public int bufferSize;
    public int fileSize;
    private String fileName;
    public native void write( int b);
    public native void open();
    public native void close();

    public NativeWrite(String fileName,int bufferSize, int file_size){
	this.fileName = fileName;
	this.bufferSize = bufferSize;
	this.fileSize = file_size;
    }

    static {
        System.loadLibrary("write");
    }
    
    public static void main(String[] args) {
	if (args.length != 3) {
	    System.err.println("<file-name> <file-size> <buffer-size>");
	    System.exit(1);
	}


        int file_size = (new Integer(args[1])).intValue();
        int buf_size = (new Integer(args[2])).intValue();

	NativeWrite mr = new NativeWrite(args[0],buf_size,file_size);

	mr.open();
	//System.out.println("Fd is "  + mr.fd);

	for(int i = 0; i < file_size; i++){
	    mr.write('c');
	}
	mr.close();
    }
}
