/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.Constants;
import org.apache.commons.csv.Quote;

public final class CSVFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final char delimiter;
    private final Character quoteChar;
    private final Quote quotePolicy;
    private final Character commentStart;
    private final Character escape;
    private final boolean ignoreSurroundingSpaces;
    private final boolean ignoreEmptyHeaders;
    private final boolean ignoreEmptyLines;
    private final String recordSeparator;
    private final String nullString;
    private final String[] header;
    private final boolean skipHeaderRecord;
    public static final CSVFormat DEFAULT = new CSVFormat(',', Constants.DOUBLE_QUOTE_CHAR, null, null, null, false, true, "\r\n", null, null, false, false);
    public static final CSVFormat RFC4180 = DEFAULT.withIgnoreEmptyLines(false);
    public static final CSVFormat EXCEL = DEFAULT.withIgnoreEmptyLines(false);
    public static final CSVFormat TDF = DEFAULT.withDelimiter('\t').withIgnoreSurroundingSpaces(true);
    public static final CSVFormat MYSQL = DEFAULT.withDelimiter('\t').withEscape('\\').withIgnoreEmptyLines(false).withQuoteChar(null).withRecordSeparator('\n');

    private static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    private static boolean isLineBreak(Character c) {
        return c != null && CSVFormat.isLineBreak(c.charValue());
    }

    public static CSVFormat newFormat(char delimiter) {
        return new CSVFormat(delimiter, null, null, null, null, false, false, null, null, null, false, false);
    }

    private CSVFormat(char delimiter, Character quoteChar, Quote quotePolicy, Character commentStart, Character escape, boolean ignoreSurroundingSpaces, boolean ignoreEmptyLines, String recordSeparator, String nullString, String[] header, boolean skipHeaderRecord, boolean ignoreEmptyHeaders) {
        if (CSVFormat.isLineBreak(delimiter)) {
            throw new IllegalArgumentException("The delimiter cannot be a line break");
        }
        this.delimiter = delimiter;
        this.quoteChar = quoteChar;
        this.quotePolicy = quotePolicy;
        this.commentStart = commentStart;
        this.escape = escape;
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
        this.ignoreEmptyHeaders = ignoreEmptyHeaders;
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.recordSeparator = recordSeparator;
        this.nullString = nullString;
        if (header == null) {
            this.header = null;
        } else {
            HashSet<String> dupCheck = new HashSet<String>();
            for (String hdr : header) {
                if (dupCheck.add(hdr)) continue;
                throw new IllegalArgumentException("The header contains a duplicate entry: '" + hdr + "' in " + Arrays.toString(header));
            }
            this.header = (String[])header.clone();
        }
        this.skipHeaderRecord = skipHeaderRecord;
        this.validate();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSVFormat other = (CSVFormat)obj;
        if (this.delimiter != other.delimiter) {
            return false;
        }
        if (this.quotePolicy != other.quotePolicy) {
            return false;
        }
        if (this.quoteChar == null ? other.quoteChar != null : !this.quoteChar.equals(other.quoteChar)) {
            return false;
        }
        if (this.commentStart == null ? other.commentStart != null : !this.commentStart.equals(other.commentStart)) {
            return false;
        }
        if (this.escape == null ? other.escape != null : !this.escape.equals(other.escape)) {
            return false;
        }
        if (this.nullString == null ? other.nullString != null : !this.nullString.equals(other.nullString)) {
            return false;
        }
        if (!Arrays.equals(this.header, other.header)) {
            return false;
        }
        if (this.ignoreSurroundingSpaces != other.ignoreSurroundingSpaces) {
            return false;
        }
        if (this.ignoreEmptyLines != other.ignoreEmptyLines) {
            return false;
        }
        if (this.skipHeaderRecord != other.skipHeaderRecord) {
            return false;
        }
        return !(this.recordSeparator == null ? other.recordSeparator != null : !this.recordSeparator.equals(other.recordSeparator));
    }

    public String format(Object ... values) {
        StringWriter out = new StringWriter();
        try {
            new CSVPrinter(out, this).printRecord(values);
            return out.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Character getCommentStart() {
        return this.commentStart;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public Character getEscape() {
        return this.escape;
    }

    public String[] getHeader() {
        return this.header != null ? (String[])this.header.clone() : null;
    }

    public boolean isIgnoringEmptyHeaders() {
        return this.ignoreEmptyHeaders;
    }

    public boolean isIgnoringEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public boolean isIgnoringSurroundingSpaces() {
        return this.ignoreSurroundingSpaces;
    }

    public String getNullString() {
        return this.nullString;
    }

    public Character getQuoteChar() {
        return this.quoteChar;
    }

    public Quote getQuotePolicy() {
        return this.quotePolicy;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public boolean isSkippingHeaderRecord() {
        return this.skipHeaderRecord;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delimiter;
        result = 31 * result + (this.quotePolicy == null ? 0 : this.quotePolicy.hashCode());
        result = 31 * result + (this.quoteChar == null ? 0 : this.quoteChar.hashCode());
        result = 31 * result + (this.commentStart == null ? 0 : this.commentStart.hashCode());
        result = 31 * result + (this.escape == null ? 0 : this.escape.hashCode());
        result = 31 * result + (this.nullString == null ? 0 : this.nullString.hashCode());
        result = 31 * result + (this.ignoreSurroundingSpaces ? 1231 : 1237);
        result = 31 * result + (this.ignoreEmptyLines ? 1231 : 1237);
        result = 31 * result + (this.skipHeaderRecord ? 1231 : 1237);
        result = 31 * result + (this.recordSeparator == null ? 0 : this.recordSeparator.hashCode());
        result = 31 * result + Arrays.hashCode(this.header);
        return result;
    }

    public boolean isCommentingEnabled() {
        return this.commentStart != null;
    }

    public boolean isEscaping() {
        return this.escape != null;
    }

    public boolean isHandlingNull() {
        return this.nullString != null;
    }

    public boolean isQuoting() {
        return this.quoteChar != null;
    }

    public CSVParser parse(Reader in) throws IOException {
        return new CSVParser(in, this);
    }

    public CSVPrinter print(Appendable out) throws IOException {
        return new CSVPrinter(out, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Delimiter=<").append(this.delimiter).append('>');
        if (this.isEscaping()) {
            sb.append(' ');
            sb.append("Escape=<").append(this.escape).append('>');
        }
        if (this.isQuoting()) {
            sb.append(' ');
            sb.append("QuoteChar=<").append(this.quoteChar).append('>');
        }
        if (this.isCommentingEnabled()) {
            sb.append(' ');
            sb.append("CommentStart=<").append(this.commentStart).append('>');
        }
        if (this.isHandlingNull()) {
            sb.append(' ');
            sb.append("NullString=<").append(this.nullString).append('>');
        }
        if (this.recordSeparator != null) {
            sb.append(' ');
            sb.append("RecordSeparator=<").append(this.recordSeparator).append('>');
        }
        if (this.isIgnoringEmptyLines()) {
            sb.append(" EmptyLines:ignored");
        }
        if (this.isIgnoringSurroundingSpaces()) {
            sb.append(" SurroundingSpaces:ignored");
        }
        sb.append(" SkipHeaderRecord:").append(this.skipHeaderRecord);
        if (this.header != null) {
            sb.append(' ');
            sb.append("Header:").append(Arrays.toString(this.header));
        }
        return sb.toString();
    }

    private void validate() throws IllegalArgumentException {
        if (this.quoteChar != null && this.delimiter == this.quoteChar.charValue()) {
            throw new IllegalArgumentException("The quoteChar character and the delimiter cannot be the same ('" + this.quoteChar + "')");
        }
        if (this.escape != null && this.delimiter == this.escape.charValue()) {
            throw new IllegalArgumentException("The escape character and the delimiter cannot be the same ('" + this.escape + "')");
        }
        if (this.commentStart != null && this.delimiter == this.commentStart.charValue()) {
            throw new IllegalArgumentException("The comment start character and the delimiter cannot be the same ('" + this.commentStart + "')");
        }
        if (this.quoteChar != null && this.quoteChar.equals(this.commentStart)) {
            throw new IllegalArgumentException("The comment start character and the quoteChar cannot be the same ('" + this.commentStart + "')");
        }
        if (this.escape != null && this.escape.equals(this.commentStart)) {
            throw new IllegalArgumentException("The comment start and the escape character cannot be the same ('" + this.commentStart + "')");
        }
        if (this.escape == null && this.quotePolicy == Quote.NONE) {
            throw new IllegalArgumentException("No quotes mode set but no escape character is set");
        }
    }

    public CSVFormat withCommentMarker(char commentMarker) {
        return this.withCommentMarker(Character.valueOf(commentMarker));
    }

    public CSVFormat withCommentMarker(Character commentMarker) {
        if (CSVFormat.isLineBreak(commentMarker)) {
            throw new IllegalArgumentException("The comment start marker character cannot be a line break");
        }
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, commentMarker, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withDelimiter(char delimiter) {
        if (CSVFormat.isLineBreak(delimiter)) {
            throw new IllegalArgumentException("The delimiter cannot be a line break");
        }
        return new CSVFormat(delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withEscape(char escape) {
        return this.withEscape(Character.valueOf(escape));
    }

    public CSVFormat withEscape(Character escape) {
        if (CSVFormat.isLineBreak(escape)) {
            throw new IllegalArgumentException("The escape character cannot be a line break");
        }
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withHeader(String ... header) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withIgnoreEmptyHeaders(boolean ignoreEmptyHeaders) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, ignoreEmptyHeaders, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, ignoreEmptyHeaders);
    }

    public CSVFormat withIgnoreEmptyLines(boolean ignoreEmptyLines) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withIgnoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withNullString(String nullString) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, nullString, this.header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withQuoteChar(char quoteChar) {
        return this.withQuoteChar(Character.valueOf(quoteChar));
    }

    public CSVFormat withQuoteChar(Character quoteChar) {
        if (CSVFormat.isLineBreak(quoteChar)) {
            throw new IllegalArgumentException("The quoteChar cannot be a line break");
        }
        return new CSVFormat(this.delimiter, quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withQuotePolicy(Quote quotePolicy) {
        return new CSVFormat(this.delimiter, this.quoteChar, quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withRecordSeparator(char recordSeparator) {
        return this.withRecordSeparator(String.valueOf(recordSeparator));
    }

    public CSVFormat withRecordSeparator(String recordSeparator) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.ignoreEmptyHeaders);
    }

    public CSVFormat withSkipHeaderRecord(boolean skipHeaderRecord) {
        return new CSVFormat(this.delimiter, this.quoteChar, this.quotePolicy, this.commentStart, this.escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, skipHeaderRecord, this.ignoreEmptyHeaders);
    }
}

