/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import weka.core.Capabilities;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.core.converters.FileSourcedConverter;
import weka.gui.ExtensionFileFilter;
import weka.gui.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -5373058011025481738L;
    public static final int UNHANDLED_DIALOG = 0;
    public static final int LOADER_DIALOG = 1;
    public static final int SAVER_DIALOG = 2;
    protected ConverterFileChooser m_Self = this;
    protected static Vector<ExtensionFileFilter> m_LoaderFileFilters;
    protected static Vector<ExtensionFileFilter> m_SaverFileFilters;
    protected int m_DialogType;
    protected Object m_CurrentConverter;
    protected JButton m_ConfigureButton;
    protected PropertyChangeListener m_Listener;
    protected FileFilter m_LastFilter;
    protected Capabilities m_CapabilitiesFilter;
    protected boolean m_OverwriteWarning = true;
    protected boolean m_FileMustExist = true;
    protected boolean m_CoreConvertersOnly = false;

    public ConverterFileChooser() {
    }

    public ConverterFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public ConverterFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    protected Vector<ExtensionFileFilter> filterNonCoreLoaderFileFilters(Vector<ExtensionFileFilter> list) {
        Vector<ExtensionFileFilter> result;
        if (!this.getCoreConvertersOnly()) {
            result = list;
        } else {
            result = new Vector();
            for (int i = 0; i < list.size(); ++i) {
                ExtensionFileFilter filter = list.get(i);
                AbstractFileLoader loader = ConverterUtils.getLoaderForExtension(filter.getExtensions()[0]);
                if (!ConverterUtils.isCoreFileLoader(loader.getClass().getName())) continue;
                result.add(filter);
            }
        }
        return result;
    }

    protected Vector<ExtensionFileFilter> filterNonCoreSaverFileFilters(Vector<ExtensionFileFilter> list) {
        Vector<ExtensionFileFilter> result;
        if (!this.getCoreConvertersOnly()) {
            result = list;
        } else {
            result = new Vector();
            for (int i = 0; i < list.size(); ++i) {
                ExtensionFileFilter filter = list.get(i);
                AbstractFileSaver saver = ConverterUtils.getSaverForExtension(filter.getExtensions()[0]);
                if (!ConverterUtils.isCoreFileSaver(saver.getClass().getName())) continue;
                result.add(filter);
            }
        }
        return result;
    }

    protected Vector<ExtensionFileFilter> filterSaverFileFilters(Vector<ExtensionFileFilter> list) {
        Vector<ExtensionFileFilter> result;
        if (this.m_CapabilitiesFilter == null) {
            result = list;
        } else {
            result = new Vector();
            for (int i = 0; i < list.size(); ++i) {
                ExtensionFileFilter filter = list.get(i);
                AbstractFileSaver saver = ConverterUtils.getSaverForExtension(filter.getExtensions()[0]);
                if (!saver.getCapabilities().supports(this.m_CapabilitiesFilter)) continue;
                result.add(filter);
            }
        }
        return result;
    }

    protected static void initFilters(boolean loader, Vector<String> classnames) {
        if (loader) {
            m_LoaderFileFilters = new Vector();
        } else {
            m_SaverFileFilters = new Vector();
        }
        for (int i = 0; i < classnames.size(); ++i) {
            ExtensionFileFilter filter;
            int n;
            String desc;
            String[] ext;
            FileSourcedConverter converter;
            Class<?> cls;
            String classname = classnames.get(i);
            try {
                cls = Class.forName(classname);
                converter = (FileSourcedConverter)cls.newInstance();
                ext = converter.getFileExtensions();
                desc = converter.getFileDescription();
            }
            catch (Exception e) {
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (loader) {
                for (n = 0; n < ext.length; ++n) {
                    filter = new ExtensionFileFilter(ext[n], desc + " (*" + ext[n] + ")");
                    m_LoaderFileFilters.add(filter);
                }
                continue;
            }
            for (n = 0; n < ext.length; ++n) {
                filter = new ExtensionFileFilter(ext[n], desc + " (*" + ext[n] + ")");
                m_SaverFileFilters.add(filter);
            }
        }
    }

    protected void initGUI(int dialogType) {
        boolean acceptAll = this.isAcceptAllFileFilterUsed();
        this.resetChoosableFileFilters();
        this.setAcceptAllFileFilterUsed(acceptAll);
        Vector<ExtensionFileFilter> list = dialogType == 1 ? this.filterNonCoreLoaderFileFilters(m_LoaderFileFilters) : this.filterSaverFileFilters(this.filterNonCoreSaverFileFilters(m_SaverFileFilters));
        for (int i = 0; i < list.size(); ++i) {
            this.addChoosableFileFilter(list.get(i));
        }
        if (list.size() > 0) {
            if (this.m_LastFilter == null || !list.contains(this.m_LastFilter)) {
                this.setFileFilter(list.get(0));
            } else {
                this.setFileFilter(this.m_LastFilter);
            }
        }
        if (this.m_Listener != null) {
            this.removePropertyChangeListener(this.m_Listener);
        }
        this.m_Listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    ConverterFileChooser.this.updateCurrentConverter();
                }
            }
        };
        this.addPropertyChangeListener(this.m_Listener);
        this.updateCurrentConverter();
    }

    public void setCapabilitiesFilter(Capabilities value) {
        this.m_CapabilitiesFilter = (Capabilities)value.clone();
    }

    public Capabilities getCapabilitiesFilter() {
        if (this.m_CapabilitiesFilter != null) {
            return (Capabilities)this.m_CapabilitiesFilter.clone();
        }
        return null;
    }

    public void setOverwriteWarning(boolean value) {
        this.m_OverwriteWarning = value;
    }

    public boolean getOverwriteWarning() {
        return this.m_OverwriteWarning;
    }

    public void setFileMustExist(boolean value) {
        this.m_FileMustExist = value;
    }

    public boolean getFileMustExist() {
        return this.m_FileMustExist;
    }

    public void setCoreConvertersOnly(boolean value) {
        this.m_CoreConvertersOnly = value;
    }

    public boolean getCoreConvertersOnly() {
        return this.m_CoreConvertersOnly;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        if (this.m_DialogType == 0) {
            Messages.getInstance();
            throw new IllegalStateException(Messages.getString("ConverterFileChooser_ShowDialog_IllegalStateException_Text"));
        }
        return super.showDialog(parent, approveButtonText);
    }

    @Override
    public int showOpenDialog(Component parent) {
        String[] extensions;
        String filename;
        this.m_DialogType = 1;
        this.m_CurrentConverter = null;
        this.initGUI(1);
        int result = super.showOpenDialog(parent);
        this.m_DialogType = 0;
        this.removePropertyChangeListener(this.m_Listener);
        if (result == 0 && this.getSelectedFile().isFile() && this.getFileFilter() instanceof ExtensionFileFilter && !(filename = this.getSelectedFile().getAbsolutePath()).endsWith((extensions = ((ExtensionFileFilter)this.getFileFilter()).getExtensions())[0])) {
            filename = filename + extensions[0];
            this.setSelectedFile(new File(filename));
        }
        if (result == 0 && this.getFileMustExist() && this.getSelectedFile().isFile() && !this.getSelectedFile().exists()) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ConverterFileChooser_ShowOpenDialog_RetVal_JOptionPaneShowConfirmDialog_Text_First")).append(this.getSelectedFile());
            Messages.getInstance();
            int retVal = JOptionPane.showConfirmDialog(parent, stringBuilder2.append(Messages.getString("ConverterFileChooser_ShowOpenDialog_RetVal_JOptionPaneShowConfirmDialog_Text_Second")).toString());
            result = retVal == 0 ? this.showOpenDialog(parent) : 1;
        }
        if (result == 0) {
            this.m_LastFilter = this.getFileFilter();
            this.configureCurrentConverter(1);
        }
        return result;
    }

    @Override
    public int showSaveDialog(Component parent) {
        String[] extensions;
        String filename;
        this.m_DialogType = 2;
        this.m_CurrentConverter = null;
        this.initGUI(2);
        boolean acceptAll = this.isAcceptAllFileFilterUsed();
        FileFilter currentFilter = this.getFileFilter();
        File currentFile = this.getSelectedFile();
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        int result = super.showSaveDialog(parent);
        if (result == 0 && this.getFileFilter() instanceof ExtensionFileFilter && !(filename = this.getSelectedFile().getAbsolutePath()).endsWith((extensions = ((ExtensionFileFilter)this.getFileFilter()).getExtensions())[0])) {
            filename = filename + extensions[0];
            this.setSelectedFile(new File(filename));
        }
        currentFilter = this.getFileFilter();
        currentFile = this.getSelectedFile();
        this.setAcceptAllFileFilterUsed(acceptAll);
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        this.m_DialogType = 0;
        this.removePropertyChangeListener(this.m_Listener);
        if (result == 0 && this.getOverwriteWarning() && this.getSelectedFile().exists()) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("")).append(this.getSelectedFile());
            Messages.getInstance();
            int retVal = JOptionPane.showConfirmDialog(parent, stringBuilder2.append(Messages.getString("ConverterFileChooser_ShowSaveDialog_RetVal_JOptionPaneShowConfirmDialog_Text_Second")).toString());
            result = retVal == 0 ? 0 : (retVal == 1 ? this.showSaveDialog(parent) : 1);
        }
        if (result == 0) {
            this.m_LastFilter = this.getFileFilter();
            this.configureCurrentConverter(2);
        }
        return result;
    }

    public AbstractFileLoader getLoader() {
        this.configureCurrentConverter(1);
        if (this.m_CurrentConverter instanceof AbstractFileSaver) {
            return null;
        }
        return (AbstractFileLoader)this.m_CurrentConverter;
    }

    public AbstractFileSaver getSaver() {
        this.configureCurrentConverter(2);
        if (this.m_CurrentConverter instanceof AbstractFileLoader) {
            return null;
        }
        return (AbstractFileSaver)this.m_CurrentConverter;
    }

    protected void updateCurrentConverter() {
        if (this.getFileFilter() == null) {
            return;
        }
        if (!this.isAcceptAllFileFilterUsed()) {
            String[] extensions = ((ExtensionFileFilter)this.getFileFilter()).getExtensions();
            EnvironmentHandler newConverter = this.m_DialogType == 1 ? ConverterUtils.getLoaderForExtension(extensions[0]) : ConverterUtils.getSaverForExtension(extensions[0]);
            try {
                if (this.m_CurrentConverter == null) {
                    this.m_CurrentConverter = newConverter;
                } else if (!this.m_CurrentConverter.getClass().equals(newConverter.getClass())) {
                    this.m_CurrentConverter = newConverter;
                }
            }
            catch (Exception e) {
                this.m_CurrentConverter = null;
                e.printStackTrace();
            }
        } else {
            this.m_CurrentConverter = null;
        }
    }

    protected void configureCurrentConverter(int dialogType) {
        if (this.getSelectedFile() == null || this.getSelectedFile().isDirectory()) {
            return;
        }
        String filename = this.getSelectedFile().getAbsolutePath();
        if (this.m_CurrentConverter == null) {
            if (dialogType == 1) {
                this.m_CurrentConverter = ConverterUtils.getLoaderForFile(filename);
            } else if (dialogType == 2) {
                this.m_CurrentConverter = ConverterUtils.getSaverForFile(filename);
            } else {
                Messages.getInstance();
                throw new IllegalStateException(Messages.getString("ConverterFileChooser_ConfigureCurrentConverter_IllegalStateException_Text"));
            }
            if (this.m_CurrentConverter == null) {
                return;
            }
        }
        try {
            File currFile = ((FileSourcedConverter)this.m_CurrentConverter).retrieveFile();
            if (currFile == null || !currFile.getAbsolutePath().equals(filename)) {
                ((FileSourcedConverter)this.m_CurrentConverter).setFile(new File(filename));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        ConverterFileChooser fc = new ConverterFileChooser();
        int retVal = fc.showOpenDialog(null);
        if (retVal == 0) {
            AbstractFileLoader loader = fc.getLoader();
            Instances data = loader.getDataSet();
            retVal = fc.showSaveDialog(null);
            if (retVal == 0) {
                AbstractFileSaver saver = fc.getSaver();
                saver.setInstances(data);
                saver.writeBatch();
            } else {
                Messages.getInstance();
                System.out.println(Messages.getString("ConverterFileChooser_Main_Text_First"));
            }
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("ConverterFileChooser_Main_Text_Second"));
        }
    }

    static {
        ConverterFileChooser.initFilters(true, ConverterUtils.getFileLoaders());
        ConverterFileChooser.initFilters(false, ConverterUtils.getFileSavers());
    }
}

