/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;
import weka.gui.ComponentHelper;
import weka.gui.arffviewer.Messages;

public class ArffTableModel
implements TableModel,
Undoable {
    private HashSet m_Listeners = new HashSet();
    private Instances m_Data = null;
    private boolean m_NotificationEnabled = true;
    private boolean m_UndoEnabled = true;
    private boolean m_IgnoreChanges = false;
    private Vector m_UndoList = new Vector();
    private boolean m_ReadOnly = false;

    private ArffTableModel() {
    }

    public ArffTableModel(String filename) {
        this();
        if (filename != null && !filename.equals("")) {
            this.loadFile(filename);
        }
    }

    public ArffTableModel(Instances data) {
        this();
        this.m_Data = data;
    }

    public boolean isNotificationEnabled() {
        return this.m_NotificationEnabled;
    }

    public void setNotificationEnabled(boolean enabled) {
        this.m_NotificationEnabled = enabled;
    }

    public boolean isUndoEnabled() {
        return this.m_UndoEnabled;
    }

    public void setUndoEnabled(boolean enabled) {
        this.m_UndoEnabled = enabled;
    }

    public boolean isReadOnly() {
        return this.m_ReadOnly;
    }

    public void setReadOnly(boolean value) {
        this.m_ReadOnly = value;
    }

    private void loadFile(String filename) {
        AbstractFileLoader loader = ConverterUtils.getLoaderForFile(filename);
        if (loader != null) {
            try {
                loader.setFile(new File(filename));
                this.m_Data = loader.getDataSet();
            }
            catch (Exception e) {
                Messages.getInstance();
                ComponentHelper.showMessageBox(null, Messages.getString("ArffTableModel_LoadFile_ComponentHelperShowMessageBox_Text"), e.toString(), 2, 0);
                System.out.println(e);
                this.m_Data = null;
            }
        }
    }

    public void setInstances(Instances data) {
        this.m_Data = data;
    }

    public Instances getInstances() {
        return this.m_Data;
    }

    public Attribute getAttributeAt(int columnIndex) {
        if (columnIndex > 0 && columnIndex < this.getColumnCount()) {
            return this.m_Data.attribute(columnIndex - 1);
        }
        return null;
    }

    public int getType(int columnIndex) {
        return this.getType(0, columnIndex);
    }

    public int getType(int rowIndex, int columnIndex) {
        int result = 2;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex > 0 && columnIndex < this.getColumnCount()) {
            result = this.m_Data.instance(rowIndex).attribute(columnIndex - 1).type();
        }
        return result;
    }

    public void deleteAttributeAt(int columnIndex) {
        this.deleteAttributeAt(columnIndex, true);
    }

    public void deleteAttributeAt(int columnIndex, boolean notify) {
        if (columnIndex > 0 && columnIndex < this.getColumnCount()) {
            if (!this.m_IgnoreChanges) {
                this.addUndoPoint();
            }
            this.m_Data.deleteAttributeAt(columnIndex - 1);
            if (notify) {
                this.notifyListener(new TableModelEvent(this, -1));
            }
        }
    }

    public void deleteAttributes(int[] columnIndices) {
        Arrays.sort(columnIndices);
        this.addUndoPoint();
        this.m_IgnoreChanges = true;
        for (int i = columnIndices.length - 1; i >= 0; --i) {
            this.deleteAttributeAt(columnIndices[i], false);
        }
        this.m_IgnoreChanges = false;
        this.notifyListener(new TableModelEvent(this, -1));
    }

    public void renameAttributeAt(int columnIndex, String newName) {
        if (columnIndex > 0 && columnIndex < this.getColumnCount()) {
            this.addUndoPoint();
            this.m_Data.renameAttribute(columnIndex - 1, newName);
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void attributeAsClassAt(int columnIndex) {
        if (columnIndex > 0 && columnIndex < this.getColumnCount()) {
            this.addUndoPoint();
            try {
                String order = "";
                for (int i = 1; i < this.m_Data.numAttributes() + 1; ++i) {
                    if (i == columnIndex) continue;
                    if (!order.equals("")) {
                        order = order + ",";
                    }
                    order = order + Integer.toString(i);
                }
                if (!order.equals("")) {
                    order = order + ",";
                }
                order = order + Integer.toString(columnIndex);
                Reorder reorder = new Reorder();
                reorder.setAttributeIndices(order);
                reorder.setInputFormat(this.m_Data);
                this.m_Data = Filter.useFilter(this.m_Data, reorder);
                this.m_Data.setClassIndex(this.m_Data.numAttributes() - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.undo();
            }
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void deleteInstanceAt(int rowIndex) {
        this.deleteInstanceAt(rowIndex, true);
    }

    public void deleteInstanceAt(int rowIndex, boolean notify) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            if (!this.m_IgnoreChanges) {
                this.addUndoPoint();
            }
            this.m_Data.delete(rowIndex);
            if (notify) {
                this.notifyListener(new TableModelEvent(this, rowIndex, rowIndex, -1, -1));
            }
        }
    }

    public void deleteInstances(int[] rowIndices) {
        Arrays.sort(rowIndices);
        this.addUndoPoint();
        this.m_IgnoreChanges = true;
        for (int i = rowIndices.length - 1; i >= 0; --i) {
            this.deleteInstanceAt(rowIndices[i], false);
        }
        this.m_IgnoreChanges = false;
        this.notifyListener(new TableModelEvent(this, rowIndices[0], rowIndices[rowIndices.length - 1], -1, -1));
    }

    public void sortInstances(int columnIndex) {
        if (columnIndex > 0 && columnIndex < this.getColumnCount()) {
            this.addUndoPoint();
            this.m_Data.sort(columnIndex - 1);
            this.notifyListener(new TableModelEvent(this));
        }
    }

    public int getAttributeColumn(String name) {
        int result = -1;
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            if (!this.m_Data.attribute(i).name().equals(name)) continue;
            result = i + 1;
            break;
        }
        return result;
    }

    public Class getColumnClass(int columnIndex) {
        Class result = null;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            result = columnIndex == 0 ? Integer.class : (this.getType(columnIndex) == 0 ? Double.class : String.class);
        }
        return result;
    }

    public int getColumnCount() {
        int result = 1;
        if (this.m_Data != null) {
            result += this.m_Data.numAttributes();
        }
        return result;
    }

    private boolean isClassIndex(int columnIndex) {
        int index = this.m_Data.classIndex();
        boolean result = index == -1 && this.m_Data.numAttributes() == columnIndex || index == columnIndex - 1;
        return result;
    }

    public String getColumnName(int columnIndex) {
        String result = "";
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            if (columnIndex == 0) {
                Messages.getInstance();
                result = Messages.getString("ArffTableModel_GetColumnName_Result_Text_First");
            } else if (this.m_Data != null && columnIndex - 1 < this.m_Data.numAttributes()) {
                Messages.getInstance();
                result = Messages.getString("ArffTableModel_GetColumnName_Result_Text_Second");
                if (this.isClassIndex(columnIndex)) {
                    StringBuilder stringBuilder = new StringBuilder().append(result);
                    Messages.getInstance();
                    StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ArffTableModel_GetColumnName_Result_Text_Third")).append(this.m_Data.attribute(columnIndex - 1).name());
                    Messages.getInstance();
                    result = stringBuilder2.append(Messages.getString("ArffTableModel_GetColumnName_Result_Text_Forth")).toString();
                } else {
                    result = result + this.m_Data.attribute(columnIndex - 1).name();
                }
                switch (this.getType(columnIndex)) {
                    case 3: {
                        StringBuilder stringBuilder = new StringBuilder().append(result);
                        Messages.getInstance();
                        result = stringBuilder.append(Messages.getString("ArffTableModel_GetColumnName_Result_Date_Text")).toString();
                        break;
                    }
                    case 1: {
                        StringBuilder stringBuilder = new StringBuilder().append(result);
                        Messages.getInstance();
                        result = stringBuilder.append(Messages.getString("ArffTableModel_GetColumnName_Result_Nominal_Text")).toString();
                        break;
                    }
                    case 2: {
                        StringBuilder stringBuilder = new StringBuilder().append(result);
                        Messages.getInstance();
                        result = stringBuilder.append(Messages.getString("ArffTableModel_GetColumnName_Result_String_Text")).toString();
                        break;
                    }
                    case 0: {
                        StringBuilder stringBuilder = new StringBuilder().append(result);
                        Messages.getInstance();
                        result = stringBuilder.append(Messages.getString("ArffTableModel_GetColumnName_Result_Numeric_Text")).toString();
                        break;
                    }
                    case 4: {
                        StringBuilder stringBuilder = new StringBuilder().append(result);
                        Messages.getInstance();
                        result = stringBuilder.append(Messages.getString("ArffTableModel_GetColumnName_Result_Relational_Text")).toString();
                        break;
                    }
                    default: {
                        StringBuilder stringBuilder = new StringBuilder().append(result);
                        Messages.getInstance();
                        result = stringBuilder.append(Messages.getString("ArffTableModel_GetColumnName_Result_Default_Text")).toString();
                    }
                }
                StringBuilder stringBuilder = new StringBuilder().append(result);
                Messages.getInstance();
                result = stringBuilder.append(Messages.getString("ArffTableModel_GetColumnName_Result_Text_End")).toString();
            }
        }
        return result;
    }

    public int getRowCount() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Data.numInstances();
    }

    public boolean isMissingAt(int rowIndex, int columnIndex) {
        boolean result = false;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex > 0 && columnIndex < this.getColumnCount()) {
            result = this.m_Data.instance(rowIndex).isMissing(columnIndex - 1);
        }
        return result;
    }

    public double getInstancesValueAt(int rowIndex, int columnIndex) {
        double result = -1.0;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex > 0 && columnIndex < this.getColumnCount()) {
            result = this.m_Data.instance(rowIndex).value(columnIndex - 1);
        }
        return result;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String tmp;
        Object result = null;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            if (columnIndex == 0) {
                result = new Integer(rowIndex + 1);
            } else if (this.isMissingAt(rowIndex, columnIndex)) {
                result = null;
            } else {
                switch (this.getType(columnIndex)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        result = this.m_Data.instance(rowIndex).stringValue(columnIndex - 1);
                        break;
                    }
                    case 0: {
                        result = new Double(this.m_Data.instance(rowIndex).value(columnIndex - 1));
                        break;
                    }
                    default: {
                        result = "-can't display-";
                    }
                }
            }
        }
        if (this.getType(columnIndex) != 0 && result != null && ((tmp = result.toString()).indexOf("\n") > -1 || tmp.indexOf("\r") > -1)) {
            tmp = tmp.replaceAll("\\r\\n", "<font color=\"red\"><b>\\\\r\\\\n</b></font>");
            tmp = tmp.replaceAll("\\r", "<font color=\"red\"><b>\\\\r</b></font>");
            tmp = tmp.replaceAll("\\n", "<font color=\"red\"><b>\\\\n</b></font>");
            result = "<html>" + tmp + "</html>";
        }
        return result;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0 && !this.isReadOnly();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAt(aValue, rowIndex, columnIndex, true);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, boolean notify) {
        if (!this.m_IgnoreChanges) {
            this.addUndoPoint();
        }
        Object oldValue = this.getValueAt(rowIndex, columnIndex);
        int type = this.getType(rowIndex, columnIndex);
        int index = columnIndex - 1;
        Instance inst = this.m_Data.instance(rowIndex);
        Attribute att = inst.attribute(index);
        if (aValue == null) {
            inst.setValue(index, Instance.missingValue());
        } else {
            String tmp = aValue.toString();
            switch (type) {
                case 3: {
                    try {
                        att.parseDate(tmp);
                        inst.setValue(index, att.parseDate(tmp));
                    }
                    catch (Exception e) {}
                    break;
                }
                case 1: {
                    if (att.indexOfValue(tmp) <= -1) break;
                    inst.setValue(index, (double)att.indexOfValue(tmp));
                    break;
                }
                case 2: {
                    inst.setValue(index, tmp);
                    break;
                }
                case 0: {
                    try {
                        Double.parseDouble(tmp);
                        inst.setValue(index, Double.parseDouble(tmp));
                    }
                    catch (Exception e) {}
                    break;
                }
                case 4: {
                    try {
                        inst.setValue(index, (double)inst.attribute(index).addRelation((Instances)aValue));
                    }
                    catch (Exception e) {}
                    break;
                }
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ArffTableModel_SetValueAt_Default_Error_Text_Front")).append(type);
                    Messages.getInstance();
                    throw new IllegalArgumentException(stringBuilder2.append(Messages.getString("ArffTableModel_SetValueAt_Default_Error_Text_End")).toString());
                }
            }
        }
        if (notify && !("" + oldValue).equals("" + aValue)) {
            this.notifyListener(new TableModelEvent(this, rowIndex, columnIndex));
        }
    }

    public void addTableModelListener(TableModelListener l) {
        this.m_Listeners.add(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.m_Listeners.remove(l);
    }

    public void notifyListener(TableModelEvent e) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        for (TableModelListener l : this.m_Listeners) {
            l.tableChanged(e);
        }
    }

    public void clearUndo() {
        this.m_UndoList = new Vector();
    }

    public boolean canUndo() {
        return !this.m_UndoList.isEmpty();
    }

    public void undo() {
        if (this.canUndo()) {
            File tempFile = (File)this.m_UndoList.get(this.m_UndoList.size() - 1);
            try {
                ObjectInputStream ooi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(tempFile)));
                Instances inst = (Instances)ooi.readObject();
                ooi.close();
                this.setInstances(inst);
                this.notifyListener(new TableModelEvent(this, -1));
                this.notifyListener(new TableModelEvent(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempFile.delete();
            this.m_UndoList.remove(this.m_UndoList.size() - 1);
        }
    }

    public void addUndoPoint() {
        if (!this.isUndoEnabled()) {
            return;
        }
        if (this.getInstances() != null) {
            try {
                File tempFile = File.createTempFile("arffviewer", null);
                tempFile.deleteOnExit();
                ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
                oos.writeObject(this.getInstances());
                oos.flush();
                oos.close();
                this.m_UndoList.add(tempFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

