/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.gui.beans.ClassValuePicker;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.DataFormatListener;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.Messages;

public class ClassValuePickerCustomizer
extends JPanel
implements Customizer,
CustomizerClosingListener,
DataFormatListener {
    private static final long serialVersionUID = 8213423053861600469L;
    private boolean m_displayValNames = false;
    private ClassValuePicker m_classValuePicker;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private JComboBox m_ClassValueCombo = new JComboBox();
    private JPanel m_holderP = new JPanel();
    private JLabel m_messageLabel;

    public ClassValuePickerCustomizer() {
        Messages.getInstance();
        this.m_messageLabel = new JLabel(Messages.getString("ClassValuePickerCustomizer_MessageLabel_JLabel_Text"));
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.setLayout(new BorderLayout());
        Messages.getInstance();
        this.add((Component)new JLabel(Messages.getString("ClassValuePickerCustomizer_JLabel_Text")), "North");
        this.m_holderP.setLayout(new BorderLayout());
        Messages.getInstance();
        this.m_holderP.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClassValuePickerCustomizer_HolderP_SetBorder_BorderFactory_CreateTitledBorder_Text")));
        this.m_holderP.add((Component)this.m_ClassValueCombo, "Center");
        this.m_ClassValueCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassValuePickerCustomizer.this.m_classValuePicker != null) {
                    ClassValuePickerCustomizer.this.m_classValuePicker.setClassValueIndex(ClassValuePickerCustomizer.this.m_ClassValueCombo.getSelectedIndex());
                }
            }
        });
        this.add((Component)this.m_messageLabel, "Center");
    }

    private void setUpNoCustPossible() {
        if (this.m_displayValNames) {
            this.remove(this.m_holderP);
            this.add((Component)this.m_messageLabel, "Center");
            this.m_displayValNames = false;
        }
        this.validate();
        this.repaint();
    }

    private void setUpValueSelection(Instances format) {
        if (format.classIndex() < 0 || format.classAttribute().isNumeric()) {
            return;
        }
        if (!this.m_displayValNames) {
            this.remove(this.m_messageLabel);
        }
        int existingClassVal = this.m_classValuePicker.getClassValueIndex();
        String[] attribValNames = new String[format.classAttribute().numValues()];
        for (int i = 0; i < attribValNames.length; ++i) {
            attribValNames[i] = format.classAttribute().value(i);
        }
        this.m_ClassValueCombo.setModel(new DefaultComboBoxModel<String>(attribValNames));
        if (attribValNames.length > 0 && existingClassVal < attribValNames.length) {
            this.m_ClassValueCombo.setSelectedIndex(existingClassVal);
        }
        if (!this.m_displayValNames) {
            this.add((Component)this.m_holderP, "Center");
            this.m_displayValNames = true;
        }
        this.validate();
        this.repaint();
    }

    public void setObject(Object object) {
        if (this.m_classValuePicker != (ClassValuePicker)object) {
            if (this.m_classValuePicker != null) {
                this.m_classValuePicker.removeDataFormatListener(this);
            }
            this.m_classValuePicker = (ClassValuePicker)object;
            this.m_classValuePicker.addDataFormatListener(this);
            if (this.m_classValuePicker.getConnectedFormat() != null) {
                this.setUpValueSelection(this.m_classValuePicker.getConnectedFormat());
            }
        }
    }

    public void customizerClosing() {
        if (this.m_classValuePicker != null) {
            Messages.getInstance();
            System.err.println(Messages.getString("ClassValuePickerCustomizer_CustomizerClosing_Text"));
            this.m_classValuePicker.removeDataFormatListener(this);
        }
    }

    public void newDataFormat(DataSetEvent dse) {
        if (dse.getDataSet() != null) {
            this.setUpValueSelection(this.m_classValuePicker.getConnectedFormat());
        } else {
            this.setUpNoCustPossible();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }
}

