/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.experiment.Experiment;
import weka.experiment.RemoteExperiment;
import weka.experiment.RemoteExperimentEvent;
import weka.experiment.RemoteExperimentListener;
import weka.gui.LogPanel;
import weka.gui.experiment.Messages;
import weka.gui.experiment.ResultsPanel;

public class RunPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1691868018596872051L;
    protected static final String NOT_RUNNING;
    protected JButton m_StartBut;
    protected JButton m_StopBut;
    protected LogPanel m_Log;
    protected Experiment m_Exp;
    protected Thread m_RunThread;
    protected ResultsPanel m_ResultsPanel;

    public void setResultsPanel(ResultsPanel rp) {
        this.m_ResultsPanel = rp;
    }

    public RunPanel() {
        Messages.getInstance();
        this.m_StartBut = new JButton(Messages.getString("RunPanel_StartBut_JButton_Text"));
        Messages.getInstance();
        this.m_StopBut = new JButton(Messages.getString("RunPanel_StopBut_JButton_Text"));
        this.m_Log = new LogPanel();
        this.m_RunThread = null;
        this.m_ResultsPanel = null;
        this.m_StartBut.addActionListener(this);
        this.m_StopBut.addActionListener(this);
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.setMnemonic('S');
        this.m_StopBut.setMnemonic('t');
        this.m_Log.statusMessage(NOT_RUNNING);
        JPanel controls = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        controls.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        controls.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        controls.add((Component)this.m_StartBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        controls.add((Component)this.m_StopBut, constraints);
        this.setLayout(new BorderLayout());
        this.add((Component)controls, "North");
        this.add((Component)this.m_Log, "Center");
    }

    public RunPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_StartBut) {
            if (this.m_RunThread == null) {
                try {
                    this.m_RunThread = new ExperimentRunner(this.m_Exp);
                    this.m_RunThread.setPriority(1);
                    this.m_RunThread.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    this.logMessage(stringBuilder.append(Messages.getString("RunPanel_ExperimentRunner_ActionPerformed_LogMessage_Text_First")).append(ex.getMessage()).toString());
                }
            }
        } else if (e.getSource() == this.m_StopBut) {
            this.m_StopBut.setEnabled(false);
            Messages.getInstance();
            this.logMessage(Messages.getString("RunPanel_ExperimentRunner_ActionPerformed_LogMessage_Text_Second"));
            if (this.m_Exp instanceof RemoteExperiment) {
                Messages.getInstance();
                this.logMessage(Messages.getString("RunPanel_ExperimentRunner_ActionPerformed_LogMessage_Text_Third"));
            }
            ((ExperimentRunner)this.m_RunThread).abortExperiment();
            this.m_RunThread = null;
        }
    }

    protected void logMessage(String message) {
        this.m_Log.logMessage(message);
    }

    protected void statusMessage(String message) {
        this.m_Log.statusMessage(message);
    }

    public static void main(String[] args) {
        try {
            boolean readExp = Utils.getFlag('l', args);
            String expFile = Utils.getOption('f', args);
            if (readExp && expFile.length() == 0) {
                Messages.getInstance();
                throw new Exception(Messages.getString("RunPanel_ExperimentRunner_Main_Exception_Text"));
            }
            Experiment exp = null;
            if (readExp) {
                FileInputStream fi = new FileInputStream(expFile);
                ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(fi));
                Object to = oi.readObject();
                exp = to instanceof RemoteExperiment ? (RemoteExperiment)to : (Experiment)to;
                oi.close();
            } else {
                exp = new Experiment();
            }
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("RunPanel_ExperimentRunner_Main_Error_Text_First")).append(exp.toString()).toString());
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("RunPanel_ExperimentRunner_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            final RunPanel sp = new RunPanel(exp);
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    System.err.println(stringBuilder.append(Messages.getString("RunPanel_ExperimentRunner_Main_Error_Text_Second")).append(sp.m_Exp.toString()).toString());
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        Messages.getInstance();
        NOT_RUNNING = Messages.getString("RunPanel_NOT_RUNNING_Text");
    }

    class ExperimentRunner
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = -5591889874714150118L;
        Experiment m_ExpCopy;

        public ExperimentRunner(Experiment exp) throws Exception {
            if (exp == null) {
                Messages.getInstance();
                System.err.println(Messages.getString("RunPanel_ExperimentRunner_Error_Text_First"));
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                System.err.println(stringBuilder.append(Messages.getString("RunPanel_ExperimentRunner_Error_Text_Second")).append(exp.toString()).toString());
            }
            Messages.getInstance();
            System.err.println(Messages.getString("RunPanel_ExperimentRunner_Error_Text_Third"));
            SerializedObject so = new SerializedObject(exp);
            Messages.getInstance();
            System.err.println(Messages.getString("RunPanel_ExperimentRunner_Error_Text_Fourth"));
            this.m_ExpCopy = (Experiment)so.getObject();
            Messages.getInstance();
            System.err.println(Messages.getString("RunPanel_ExperimentRunner_Error_Text_Fifth"));
        }

        public void abortExperiment() {
            if (this.m_ExpCopy instanceof RemoteExperiment) {
                ((RemoteExperiment)this.m_ExpCopy).abortExperiment();
                RunPanel.this.m_StopBut.setEnabled(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            RunPanel.this.m_StartBut.setEnabled(false);
            RunPanel.this.m_StopBut.setEnabled(true);
            if (RunPanel.this.m_ResultsPanel != null) {
                RunPanel.this.m_ResultsPanel.setExperiment(null);
            }
            try {
                block20: {
                    try {
                        if (this.m_ExpCopy instanceof RemoteExperiment) {
                            Messages.getInstance();
                            System.err.println(Messages.getString("RunPanel_ExperimentRunner_Run_Error_Text"));
                            ((RemoteExperiment)this.m_ExpCopy).addRemoteExperimentListener(new RemoteExperimentListener(){

                                public void remoteExperimentStatus(RemoteExperimentEvent e) {
                                    if (e.m_statusMessage) {
                                        RunPanel.this.statusMessage(e.m_messageString);
                                    }
                                    if (e.m_logMessage) {
                                        RunPanel.this.logMessage(e.m_messageString);
                                    }
                                    if (e.m_experimentFinished) {
                                        RunPanel.this.m_RunThread = null;
                                        RunPanel.this.m_StartBut.setEnabled(true);
                                        RunPanel.this.m_StopBut.setEnabled(false);
                                        RunPanel.this.statusMessage(NOT_RUNNING);
                                    }
                                }
                            });
                        }
                        Messages.getInstance();
                        RunPanel.this.logMessage(Messages.getString("RunPanel_ExperimentRunner_Run_LogMessage_Text_First"));
                        Messages.getInstance();
                        RunPanel.this.statusMessage(Messages.getString("RunPanel_ExperimentRunner_Run_StatusMessage_Text_First"));
                        this.m_ExpCopy.initialize();
                        int errors = 0;
                        if (!(this.m_ExpCopy instanceof RemoteExperiment)) {
                            Messages.getInstance();
                            RunPanel.this.statusMessage(Messages.getString("RunPanel_ExperimentRunner_Run_StatusMessage_Text_Second"));
                            while (RunPanel.this.m_RunThread != null && this.m_ExpCopy.hasMoreIterations()) {
                                try {
                                    Messages.getInstance();
                                    String current = Messages.getString("RunPanel_ExperimentRunner_Run_Current_Text_First");
                                    if (this.m_ExpCopy.getUsePropertyIterator()) {
                                        int cnum = this.m_ExpCopy.getCurrentPropertyNumber();
                                        String ctype = this.m_ExpCopy.getPropertyArray().getClass().getComponentType().getName();
                                        int lastDot = ctype.lastIndexOf(46);
                                        if (lastDot != -1) {
                                            ctype = ctype.substring(lastDot + 1);
                                        }
                                        String cname = " " + ctype + "=" + (cnum + 1) + ":" + this.m_ExpCopy.getPropertyArrayValue(cnum).getClass().getName();
                                        current = current + cname;
                                    }
                                    String dname = ((File)this.m_ExpCopy.getDatasets().elementAt(this.m_ExpCopy.getCurrentDatasetNumber())).getName();
                                    StringBuilder stringBuilder = new StringBuilder().append(current);
                                    Messages.getInstance();
                                    StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("RunPanel_ExperimentRunner_Run_Current_Text_Second")).append(dname);
                                    Messages.getInstance();
                                    current = stringBuilder2.append(Messages.getString("RunPanel_ExperimentRunner_Run_Current_Text_Third")).append(this.m_ExpCopy.getCurrentRunNumber()).toString();
                                    RunPanel.this.statusMessage(current);
                                    this.m_ExpCopy.nextIteration();
                                }
                                catch (Exception ex) {
                                    ++errors;
                                    RunPanel.this.logMessage(ex.getMessage());
                                    ex.printStackTrace();
                                    boolean continueAfterError = false;
                                    if (continueAfterError) {
                                        this.m_ExpCopy.advanceCounters();
                                        continue;
                                    }
                                    RunPanel.this.m_RunThread = null;
                                }
                            }
                            Messages.getInstance();
                            RunPanel.this.statusMessage(Messages.getString("RunPanel_ExperimentRunner_Run_StatusMessage_Text_Third"));
                            this.m_ExpCopy.postProcess();
                            if (RunPanel.this.m_RunThread == null) {
                                Messages.getInstance();
                                RunPanel.this.logMessage(Messages.getString("RunPanel_ExperimentRunner_Run_LogMessage_Text_Third"));
                            } else {
                                Messages.getInstance();
                                RunPanel.this.logMessage(Messages.getString("RunPanel_ExperimentRunner_Run_LogMessage_Text_Fourth"));
                            }
                            if (errors == 1) {
                                StringBuilder stringBuilder = new StringBuilder();
                                Messages.getInstance();
                                StringBuilder stringBuilder3 = stringBuilder.append(Messages.getString("RunPanel_ExperimentRunner_Run_LogMessage_Text_Fifth_Front")).append(errors);
                                Messages.getInstance();
                                RunPanel.this.logMessage(stringBuilder3.append(Messages.getString("RunPanel_ExperimentRunner_Run_LogMessage_Text_Fifth_End")).toString());
                            } else {
                                StringBuilder stringBuilder = new StringBuilder();
                                Messages.getInstance();
                                StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("RunPanel_ExperimentRunner_Run_LogMessage_Text_Sixth_Front")).append(errors);
                                Messages.getInstance();
                                RunPanel.this.logMessage(stringBuilder4.append(Messages.getString("RunPanel_ExperimentRunner_Run_LogMessage_Text_Sixth_End")).toString());
                            }
                            RunPanel.this.statusMessage(NOT_RUNNING);
                            break block20;
                        }
                        Messages.getInstance();
                        RunPanel.this.statusMessage(Messages.getString("RunPanel_ExperimentRunner_Run_StatusMessage_Text_Fourth"));
                        ((RemoteExperiment)this.m_ExpCopy).runExperiment();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.err.println(ex.getMessage());
                        RunPanel.this.statusMessage(ex.getMessage());
                        Object var8_12 = null;
                        if (RunPanel.this.m_ResultsPanel != null) {
                            RunPanel.this.m_ResultsPanel.setExperiment(this.m_ExpCopy);
                        }
                        if (this.m_ExpCopy instanceof RemoteExperiment) return;
                        RunPanel.this.m_RunThread = null;
                        RunPanel.this.m_StartBut.setEnabled(true);
                        RunPanel.this.m_StopBut.setEnabled(false);
                        Messages.getInstance();
                        System.err.println(Messages.getString("RunPanel_ExperimentRunner_Run_Error_Text"));
                        return;
                    }
                }
                Object var8_11 = null;
                if (RunPanel.this.m_ResultsPanel != null) {
                    RunPanel.this.m_ResultsPanel.setExperiment(this.m_ExpCopy);
                }
                if (this.m_ExpCopy instanceof RemoteExperiment) return;
                RunPanel.this.m_RunThread = null;
                RunPanel.this.m_StartBut.setEnabled(true);
                RunPanel.this.m_StopBut.setEnabled(false);
                Messages.getInstance();
                System.err.println(Messages.getString("RunPanel_ExperimentRunner_Run_Error_Text"));
                return;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                if (RunPanel.this.m_ResultsPanel != null) {
                    RunPanel.this.m_ResultsPanel.setExperiment(this.m_ExpCopy);
                }
                if (this.m_ExpCopy instanceof RemoteExperiment) throw throwable;
                RunPanel.this.m_RunThread = null;
                RunPanel.this.m_StartBut.setEnabled(true);
                RunPanel.this.m_StopBut.setEnabled(false);
                Messages.getInstance();
                System.err.println(Messages.getString("RunPanel_ExperimentRunner_Run_Error_Text"));
                throw throwable;
            }
        }
    }
}

