/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.tokens;

import com.wcohen.ss.api.SourcedToken;
import com.wcohen.ss.api.SourcedTokenizer;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.tokens.BasicSourcedToken;
import com.wcohen.ss.tokens.SimpleTokenizer;
import java.util.Map;
import java.util.TreeMap;

public class SimpleSourcedTokenizer
extends SimpleTokenizer
implements SourcedTokenizer {
    private int nextId = 0;
    private Map tokMap = new TreeMap();
    public static final SimpleSourcedTokenizer DEFAULT_SOURCED_TOKENIZER = new SimpleSourcedTokenizer(true, true);

    public SimpleSourcedTokenizer(boolean ignorePunctuation, boolean ignoreCase) {
        super(ignorePunctuation, ignoreCase);
    }

    @Override
    public SourcedToken[] sourcedTokenize(String input, String source) {
        Token[] tokens = this.tokenize(input);
        SourcedToken[] sourcedTokens = new SourcedToken[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String key = tokens[i].getValue() + "@" + source;
            if (this.tokMap.get(key) == null) {
                this.tokMap.put(key, new Integer(++this.nextId));
            }
            int id = (Integer)this.tokMap.get(key);
            sourcedTokens[i] = new BasicSourcedToken(id, tokens[i].getValue(), source);
        }
        return sourcedTokens;
    }

    public static void main(String[] argv) {
        SimpleSourcedTokenizer tokenizer = DEFAULT_SOURCED_TOKENIZER;
        int n = 0;
        for (int i = 0; i < argv.length; ++i) {
            System.out.println("argument " + i + ": '" + argv[i] + "'");
            SourcedToken[] tokens = tokenizer.sourcedTokenize(argv[i], Integer.toString(i));
            for (int j = 0; j < tokens.length; ++j) {
                System.out.println("token " + ++n + ":" + " id=" + tokens[j].getIndex() + " value: '" + tokens[j].getValue() + "' source: '" + tokens[j].getSource() + "'");
            }
        }
    }
}

