/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.tokens;

import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.BasicToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SimpleTokenizer
implements Tokenizer {
    public static final SimpleTokenizer DEFAULT_TOKENIZER = new SimpleTokenizer(true, true);
    private boolean ignorePunctuation = true;
    private boolean ignoreCase = true;
    private int nextId = 0;
    private Map tokMap = new TreeMap();

    public SimpleTokenizer(boolean ignorePunctuation, boolean ignoreCase) {
        this.ignorePunctuation = ignorePunctuation;
        this.ignoreCase = ignoreCase;
    }

    public void setIgnorePunctuation(boolean flag) {
        this.ignorePunctuation = flag;
    }

    public void setIgnoreCase(boolean flag) {
        this.ignoreCase = flag;
    }

    public String toString() {
        return "[SimpleTokenizer " + this.ignorePunctuation + ";" + this.ignoreCase + "]";
    }

    @Override
    public Token[] tokenize(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int cursor = 0;
        while (cursor < input.length()) {
            StringBuffer buf;
            char ch = input.charAt(cursor);
            if (Character.isWhitespace(ch)) {
                ++cursor;
                continue;
            }
            if (Character.isLetter(ch)) {
                buf = new StringBuffer("");
                while (cursor < input.length() && Character.isLetter(input.charAt(cursor))) {
                    buf.append(input.charAt(cursor));
                    ++cursor;
                }
                tokens.add(this.internSomething(buf.toString()));
                continue;
            }
            if (Character.isDigit(ch)) {
                buf = new StringBuffer("");
                while (cursor < input.length() && Character.isDigit(input.charAt(cursor))) {
                    buf.append(input.charAt(cursor));
                    ++cursor;
                }
                tokens.add(this.internSomething(buf.toString()));
                continue;
            }
            if (!this.ignorePunctuation) {
                buf = new StringBuffer("");
                buf.append(ch);
                String str = buf.toString();
                tokens.add(this.internSomething(str));
            }
            ++cursor;
        }
        return tokens.toArray(new BasicToken[tokens.size()]);
    }

    private Token internSomething(String s) {
        return this.intern(this.ignoreCase ? s.toLowerCase() : s);
    }

    @Override
    public Token intern(String s) {
        Token tok = (Token)this.tokMap.get(s);
        if (tok == null) {
            tok = new BasicToken(++this.nextId, s);
            this.tokMap.put(s, tok);
        }
        return tok;
    }

    @Override
    public Iterator tokenIterator() {
        return this.tokMap.values().iterator();
    }

    @Override
    public int maxTokenIndex() {
        return this.nextId;
    }

    public static void main(String[] argv) {
        SimpleTokenizer tokenizer = DEFAULT_TOKENIZER;
        int n = 0;
        for (int i = 0; i < argv.length; ++i) {
            System.out.println("argument " + i + ": '" + argv[i] + "'");
            Token[] tokens = tokenizer.tokenize(argv[i]);
            for (int j = 0; j < tokens.length; ++j) {
                System.out.println("token " + ++n + ":" + " id=" + tokens[j].getIndex() + " value: '" + tokens[j].getValue() + "'");
            }
        }
    }
}

