/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.daos;

import com.walmart.productgenome.matching.daos.TableDao;
import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.data.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InputMismatchException;

public class BlockingDao {
    public static final Attribute PAIR_ID_ATTRIBUTE = new Attribute("pairId", Attribute.Type.INTEGER);

    public static Table block(String projectName, String table1Name, String table2Name, String attr1Name, String attr2Name, String candsetName, String[] table1AttributeNames, String[] table2AttributeNames) throws IOException {
        Attribute attribute;
        String attributeName;
        int n;
        int n2;
        String[] stringArray;
        Table table1 = TableDao.open(projectName, table1Name);
        Table table2 = TableDao.open(projectName, table2Name);
        Attribute attribute1 = table1.getAttributeByName(attr1Name);
        Attribute attribute2 = table2.getAttributeByName(attr2Name);
        if (attribute1.getType() != attribute2.getType()) {
            throw new InputMismatchException("Blocking attributes must be of the same type");
        }
        Attribute idAttribute1 = table1.getIdAttribute();
        HashMap<Object, Object> index = new HashMap<Object, Object>();
        for (Tuple tuple : table1.getAllTuples()) {
            Object value = tuple.getAttributeValue(attribute1);
            Object tupleId = tuple.getAttributeValue(idAttribute1);
            if (value == null || !(value instanceof String) || ((String)value).isEmpty()) continue;
            index.put(value, tupleId);
        }
        String id1Name = String.valueOf(table1Name) + "." + idAttribute1.getName();
        Attribute id1 = new Attribute(id1Name, idAttribute1.getType());
        Attribute idAttribute2 = table2.getIdAttribute();
        String id2Name = String.valueOf(table2Name) + "." + idAttribute2.getName();
        Attribute id2 = new Attribute(id2Name, idAttribute2.getType());
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(PAIR_ID_ATTRIBUTE);
        attributes.add(id1);
        attributes.add(id2);
        if (table1AttributeNames != null) {
            stringArray = table1AttributeNames;
            n2 = table1AttributeNames.length;
            n = 0;
            while (n < n2) {
                attributeName = stringArray[n];
                attribute = table1.getAttributeByName(attributeName);
                attributes.add(new Attribute(String.valueOf(table1Name) + "." + attributeName, attribute.getType()));
                ++n;
            }
        }
        if (table2AttributeNames != null) {
            stringArray = table2AttributeNames;
            n2 = table2AttributeNames.length;
            n = 0;
            while (n < n2) {
                attributeName = stringArray[n];
                attribute = table2.getAttributeByName(attributeName);
                attributes.add(new Attribute(String.valueOf(table2Name) + "." + attributeName, attribute.getType()));
                ++n;
            }
        }
        Table candset = new Table(candsetName, PAIR_ID_ATTRIBUTE, attributes, projectName);
        HashMap<Attribute, Object> data = new HashMap<Attribute, Object>();
        int pairId = 1;
        for (Tuple tuple : table2.getAllTuplesInOrder()) {
            Object attributeValue;
            Attribute attribute3;
            String attributeName2;
            int n3;
            int n4;
            String[] stringArray2;
            Object value = tuple.getAttributeValue(attribute2);
            Object tupleId = tuple.getAttributeValue(idAttribute2);
            if (!index.containsKey(value)) continue;
            Object id1Val = index.get(value);
            data.put(PAIR_ID_ATTRIBUTE, pairId);
            data.put(id1, id1Val);
            data.put(id2, tupleId);
            int i = 3;
            Tuple table1Tuple = table1.getTuple(id1Val);
            if (table1AttributeNames != null) {
                stringArray2 = table1AttributeNames;
                n4 = table1AttributeNames.length;
                n3 = 0;
                while (n3 < n4) {
                    attributeName2 = stringArray2[n3];
                    attribute3 = table1.getAttributeByName(attributeName2);
                    attributeValue = table1Tuple.getAttributeValue(attribute3);
                    data.put((Attribute)attributes.get(i), attributeValue);
                    ++i;
                    ++n3;
                }
            }
            if (table2AttributeNames != null) {
                stringArray2 = table2AttributeNames;
                n4 = table2AttributeNames.length;
                n3 = 0;
                while (n3 < n4) {
                    attributeName2 = stringArray2[n3];
                    attribute3 = table2.getAttributeByName(attributeName2);
                    attributeValue = tuple.getAttributeValue(attribute3);
                    data.put((Attribute)attributes.get(i), attributeValue);
                    ++i;
                    ++n3;
                }
            }
            Tuple pair = new Tuple(data);
            candset.addTuple(pair);
            ++pairId;
            data.clear();
        }
        return candset;
    }
}

