/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.daos;

import com.walmart.productgenome.matching.daos.ProjectDao;
import com.walmart.productgenome.matching.daos.TableDao;
import com.walmart.productgenome.matching.models.audit.ItemPairAudit;
import com.walmart.productgenome.matching.models.audit.MatchStatus;
import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.models.rules.Matcher;
import com.walmart.productgenome.matching.service.debug.MatchingSummary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MatchingDao {
    public static Table match(String projectName, String candsetName, String matcherName, String matchesName, String[] table1AttributeNames, String[] table2AttributeNames) throws IOException {
        Project project = ProjectDao.open(projectName);
        Matcher matcher = project.findMatcherByName(matcherName);
        String table1Name = matcher.getTable1Name();
        String table2Name = matcher.getTable2Name();
        Table table1 = TableDao.open(projectName, table1Name);
        Table table2 = TableDao.open(projectName, table2Name);
        Table candset = TableDao.open(projectName, candsetName);
        return MatchingDao.getMatches(projectName, candset, table1, table2, matcher, matchesName, table1AttributeNames, table2AttributeNames);
    }

    public static Table match(String projectName, Table candset, Table table1, Table table2, String matcherName, String matchesName, String[] table1AttributeNames, String[] table2AttributeNames) throws IOException {
        Project project = ProjectDao.open(projectName);
        Matcher matcher = project.findMatcherByName(matcherName);
        return MatchingDao.getMatches(projectName, candset, table1, table2, matcher, matchesName, table1AttributeNames, table2AttributeNames);
    }

    public static Table match(String projectName, String candsetName, String matcherName, String matchesName, Map<Tuple, ItemPairAudit> itemPairAudits, String[] table1AttributeNames, String[] table2AttributeNames) throws IOException {
        Project project = ProjectDao.open(projectName);
        Matcher matcher = project.findMatcherByName(matcherName);
        String table1Name = matcher.getTable1Name();
        String table2Name = matcher.getTable2Name();
        Table candset = TableDao.open(projectName, candsetName);
        Table table1 = TableDao.open(projectName, table1Name);
        Table table2 = TableDao.open(projectName, table2Name);
        return MatchingDao.getMatches(projectName, candset, table1, table2, matcher, matchesName, itemPairAudits, table1AttributeNames, table2AttributeNames);
    }

    public static Table match(String projectName, Table candset, Table table1, Table table2, String matcherName, String matchesName, Map<Tuple, ItemPairAudit> itemPairAudits, String[] table1AttributeNames, String[] table2AttributeNames) throws IOException {
        Project project = ProjectDao.open(projectName);
        Matcher matcher = project.findMatcherByName(matcherName);
        return MatchingDao.getMatches(projectName, candset, table1, table2, matcher, matchesName, itemPairAudits, table1AttributeNames, table2AttributeNames);
    }

    public static void addMatchingSummary(String projectName, MatchingSummary matchingSummary) throws IOException {
        Project project = ProjectDao.open(projectName);
        project.addMatchingSummary(matchingSummary);
    }

    private static Table createMatchesTable(String projectName, Table candset, Table table1, Table table2, String matchesName, List<Attribute> matchesAttributes, String[] table1AttributeNames, String[] table2AttributeNames, List<Attribute> table1Attributes, List<Attribute> table2Attributes) {
        Attribute attribute;
        String attributeName;
        int n;
        int n2;
        String[] stringArray;
        List<Attribute> candsetAttributes = candset.getAttributes();
        Attribute pairIdAttribute = candsetAttributes.get(0);
        Attribute idAttribute1 = candsetAttributes.get(1);
        Attribute idAttribute2 = candsetAttributes.get(2);
        Attribute labelAttribute = new Attribute("label", Attribute.Type.INTEGER);
        matchesAttributes.add(pairIdAttribute);
        matchesAttributes.add(idAttribute1);
        matchesAttributes.add(idAttribute2);
        if (table1AttributeNames != null) {
            stringArray = table1AttributeNames;
            n2 = table1AttributeNames.length;
            n = 0;
            while (n < n2) {
                attributeName = stringArray[n];
                attribute = table1.getAttributeByName(attributeName);
                table1Attributes.add(attribute);
                matchesAttributes.add(new Attribute(String.valueOf(table1.getName()) + "." + attributeName, attribute.getType()));
                ++n;
            }
        }
        if (table2AttributeNames != null) {
            stringArray = table2AttributeNames;
            n2 = table2AttributeNames.length;
            n = 0;
            while (n < n2) {
                attributeName = stringArray[n];
                attribute = table2.getAttributeByName(attributeName);
                table2Attributes.add(attribute);
                matchesAttributes.add(new Attribute(String.valueOf(table2.getName()) + "." + attributeName, attribute.getType()));
                ++n;
            }
        }
        matchesAttributes.add(labelAttribute);
        Table matches = new Table(matchesName, pairIdAttribute, matchesAttributes, projectName);
        return matches;
    }

    private static Table getMatches(String projectName, Table candset, Table table1, Table table2, Matcher matcher, String matchesName, String[] table1AttributeNames, String[] table2AttributeNames) throws IOException {
        ArrayList<Attribute> matchesAttributes = new ArrayList<Attribute>();
        ArrayList<Attribute> table1Attributes = new ArrayList<Attribute>();
        ArrayList<Attribute> table2Attributes = new ArrayList<Attribute>();
        Table matches = MatchingDao.createMatchesTable(projectName, candset, table1, table2, matchesName, matchesAttributes, table1AttributeNames, table2AttributeNames, table1Attributes, table2Attributes);
        List<Tuple> matchedPairs = MatchingDao.getMatchedPairs(candset, table1, table2, matcher, matchesAttributes, table1Attributes, table2Attributes);
        System.out.println("No. of matched pairs: " + matchedPairs.size());
        matches.addAllTuples(matchedPairs);
        return matches;
    }

    private static Table getMatches(String projectName, Table candset, Table table1, Table table2, Matcher matcher, String matchesName, Map<Tuple, ItemPairAudit> itemPairAudits, String[] table1AttributeNames, String[] table2AttributeNames) throws IOException {
        ArrayList<Attribute> matchesAttributes = new ArrayList<Attribute>();
        ArrayList<Attribute> table1Attributes = new ArrayList<Attribute>();
        ArrayList<Attribute> table2Attributes = new ArrayList<Attribute>();
        Table matches = MatchingDao.createMatchesTable(projectName, candset, table1, table2, matchesName, matchesAttributes, table1AttributeNames, table2AttributeNames, table1Attributes, table2Attributes);
        List<Tuple> matchedPairs = MatchingDao.getMatchedPairs(candset, table1, table2, matcher, matchesAttributes, table1Attributes, table2Attributes, itemPairAudits);
        matches.addAllTuples(matchedPairs);
        return matches;
    }

    private static List<Tuple> getMatchedPairs(Table candset, Table table1, Table table2, Matcher matcher, List<Attribute> matchesAttributes, List<Attribute> table1Attributes, List<Attribute> table2Attributes) throws IOException {
        ArrayList<Tuple> matchedPairs = new ArrayList<Tuple>();
        for (Tuple t : candset.getAllTuplesInOrder()) {
            MatchingDao.addMatchedPair(t, table1, table2, matcher, matchesAttributes, matchedPairs, table1Attributes, table2Attributes);
        }
        return matchedPairs;
    }

    private static List<Tuple> getMatchedPairs(Table candset, Table table1, Table table2, Matcher matcher, List<Attribute> matchesAttributes, List<Attribute> table1Attributes, List<Attribute> table2Attributes, Map<Tuple, ItemPairAudit> itemPairAudits) throws IOException {
        ArrayList<Tuple> matchedPairs = new ArrayList<Tuple>();
        for (Tuple t : candset.getAllTuplesInOrder()) {
            ItemPairAudit itemPairAudit = new ItemPairAudit(t);
            MatchStatus result = MatchingDao.addMatchedPair(t, table1, table2, matcher, matchesAttributes, matchedPairs, table1Attributes, table2Attributes, itemPairAudit);
            itemPairAudit.setStatus(result);
            itemPairAudits.put(t, itemPairAudit);
        }
        return matchedPairs;
    }

    private static Map<Attribute, Object> getMatchedPairData(List<Attribute> matchesAttributes, Tuple candsetTuple, Tuple tuple1, Tuple tuple2, Matcher matcher, List<Attribute> table1Attributes, List<Attribute> table2Attributes) {
        Object attributeValue;
        HashMap<Attribute, Object> data = new HashMap<Attribute, Object>();
        Attribute pairIdAttribute = matchesAttributes.get(0);
        Object pairId = candsetTuple.getAttributeValue(pairIdAttribute);
        data.put(pairIdAttribute, pairId);
        int i = 3;
        for (Attribute attribute : table1Attributes) {
            attributeValue = tuple1.getAttributeValue(attribute);
            data.put(matchesAttributes.get(i), attributeValue);
            ++i;
        }
        for (Attribute attribute : table2Attributes) {
            attributeValue = tuple2.getAttributeValue(attribute);
            data.put(matchesAttributes.get(i), attributeValue);
            ++i;
        }
        return data;
    }

    private static MatchStatus addMatchedPair(Tuple candsetTuple, Table table1, Table table2, Matcher matcher, List<Attribute> matchesAttributes, List<Tuple> matchedPairs, List<Attribute> table1Attributes, List<Attribute> table2Attributes) throws IOException {
        Attribute idAttribute1 = matchesAttributes.get(1);
        Attribute idAttribute2 = matchesAttributes.get(2);
        Object id1 = candsetTuple.getAttributeValue(idAttribute1);
        Object id2 = candsetTuple.getAttributeValue(idAttribute2);
        Tuple tuple1 = table1.getTuple(id1);
        Tuple tuple2 = table2.getTuple(id2);
        Map<Attribute, Object> data = MatchingDao.getMatchedPairData(matchesAttributes, candsetTuple, tuple1, tuple2, matcher, table1Attributes, table2Attributes);
        data.put(idAttribute1, id1);
        data.put(idAttribute2, id2);
        MatchStatus result = matcher.evaluate(tuple1, tuple2);
        Attribute labelAttribute = matchesAttributes.get(matchesAttributes.size() - 1);
        data.put(labelAttribute, result.getLabel());
        matchedPairs.add(new Tuple(data));
        return result;
    }

    private static MatchStatus addMatchedPair(Tuple candsetTuple, Table table1, Table table2, Matcher matcher, List<Attribute> matchesAttributes, List<Tuple> matchedPairs, List<Attribute> table1Attributes, List<Attribute> table2Attributes, ItemPairAudit itemPairAudit) throws IOException {
        Attribute idAttribute1 = matchesAttributes.get(1);
        Attribute idAttribute2 = matchesAttributes.get(2);
        Object id1 = candsetTuple.getAttributeValue(idAttribute1);
        Object id2 = candsetTuple.getAttributeValue(idAttribute2);
        Tuple tuple1 = table1.getTuple(id1);
        Tuple tuple2 = table2.getTuple(id2);
        Map<Attribute, Object> data = MatchingDao.getMatchedPairData(matchesAttributes, candsetTuple, tuple1, tuple2, matcher, table1Attributes, table2Attributes);
        data.put(idAttribute1, id1);
        data.put(idAttribute2, id2);
        MatchStatus result = matcher.evaluate(tuple1, tuple2, itemPairAudit);
        Attribute labelAttribute = matchesAttributes.get(matchesAttributes.size() - 1);
        data.put(labelAttribute, result.getLabel());
        matchedPairs.add(new Tuple(data));
        return result;
    }
}

