/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.daos;

import com.walmart.productgenome.matching.daos.RuleDao;
import com.walmart.productgenome.matching.daos.TableDao;
import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.utils.JSONUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectDao {
    private static Map<String, Project> projectMap = new HashMap<String, Project>();

    static {
        List<Project> projects = ProjectDao.findAll();
        for (Project p : projects) {
            projectMap.put(p.getName(), p);
        }
    }

    public static Project open(String name) {
        return projectMap.get(name);
    }

    public static List<Project> list() {
        return new ArrayList<Project>(projectMap.values());
    }

    public static void save(Project project) throws IOException {
        String projectName = project.getName();
        if (project.hasUnsavedArtifacts()) {
            if (!project.getUnsavedTables().isEmpty()) {
                TableDao.saveAllTables(projectName);
            }
            if (!project.getUnsavedFunctions().isEmpty()) {
                RuleDao.saveAllFunctions(projectName);
            }
            if (!project.getUnsavedFeatures().isEmpty()) {
                RuleDao.saveAllFeatures(projectName);
            }
            if (!project.getUnsavedRules().isEmpty()) {
                RuleDao.saveAllRules(projectName);
            }
            if (!project.getUnsavedMatchers().isEmpty()) {
                RuleDao.saveAllMatchers(projectName);
            }
        }
        project.setLastModifiedOn(new Date());
        File projectDir = new File("./ems/" + projectName);
        if (!projectDir.exists()) {
            System.out.println("Creating directory: " + project.getName());
            boolean result = false;
            try {
                projectDir.mkdir();
                result = true;
            }
            catch (SecurityException se) {
                se.printStackTrace();
            }
            if (result) {
                System.out.println("DIR created");
            }
        }
        String json = JSONUtils.getProjectJSON(project);
        try {
            FileWriter fw = new FileWriter("./ems/" + projectName + "/" + projectName + ".project");
            fw.write(json);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        projectMap.put(project.getName(), project);
    }

    public static void updateProject(Project project) {
        projectMap.put(project.getName(), project);
    }

    static List<Project> findAll() {
        File[] files;
        ArrayList<Project> projects = new ArrayList<Project>();
        File dir = new File("./ems/");
        File[] fileArray = files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                if (f.isDirectory()) {
                    String projectName = f.getName();
                    Project p = JSONUtils.getProjectFromJSONFile(projectName);
                    projects.add(p);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return projects;
    }

    public static void createNewProject(String projectName, String projectDescription) throws SecurityException, IllegalArgumentException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Project project = new Project(projectName, projectDescription);
        ProjectDao.save(project);
        RuleDao.importFunctions(project, "./ems/global/all.functions", true);
        ProjectDao.save(project);
    }

    public static void setDefaults(String projectName, String table1Name, String table2Name, String candsetName, String matchesName, String goldName, boolean saveToDisk) throws IOException {
        Project project = ProjectDao.open(projectName);
        List<String> tableNames = project.getTableNames();
        if (tableNames.contains(table1Name)) {
            project.setDefaultTable1(table1Name);
        }
        if (tableNames.contains(table2Name)) {
            project.setDefaultTable2(table2Name);
        }
        if (tableNames.contains(candsetName)) {
            project.setDefaultCandset(candsetName);
        }
        if (tableNames.contains(matchesName)) {
            project.setDefaultMatches(matchesName);
        }
        if (tableNames.contains(goldName)) {
            project.setDefaultGold(goldName);
        }
        if (saveToDisk) {
            ProjectDao.save(project);
        }
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        ProjectDao.save(new Project("Products", "Amazon-Walmart"));
        for (Project p : projectMap.values()) {
            System.out.println(p);
        }
        Thread.sleep(2000L);
        Project project = ProjectDao.open("Products");
        project.setDescription("Product Matching between Amazon and Walmart");
        ProjectDao.save(project);
        for (Project p : projectMap.values()) {
            System.out.println(p);
        }
    }
}

