/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.daos;

import com.walmart.productgenome.matching.daos.ProjectDao;
import com.walmart.productgenome.matching.daos.TableDao;
import com.walmart.productgenome.matching.models.RelationalOperator;
import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.rules.Feature;
import com.walmart.productgenome.matching.models.rules.Matcher;
import com.walmart.productgenome.matching.models.rules.Rule;
import com.walmart.productgenome.matching.models.rules.Term;
import com.walmart.productgenome.matching.models.rules.functions.Function;
import com.walmart.productgenome.matching.models.savers.FeatureSaver;
import com.walmart.productgenome.matching.models.savers.FunctionSaver;
import com.walmart.productgenome.matching.models.savers.MatcherSaver;
import com.walmart.productgenome.matching.models.savers.RuleSaver;
import com.walmart.productgenome.matching.utils.CSVUtils;
import com.walmart.productgenome.matching.utils.ParsingUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class RuleDao {
    public static List<Feature> importFeaturesFromCSVWithHeader(Project project, Table table1, Table table2, String csvFeatureFilePath) throws IOException {
        return CSVUtils.readFeatures(project, table1, table2, csvFeatureFilePath);
    }

    public static List<Rule> importRulesFromCSVWithHeader(Project project, String table1Name, String table2Name, String csvRuleFilePath) throws IOException {
        return CSVUtils.readRules(project, table1Name, table2Name, csvRuleFilePath);
    }

    public static List<Matcher> importMatchersFromCSVWithHeader(Project project, String table1Name, String table2Name, String csvMatcherFilePath) throws IOException {
        return CSVUtils.readMatchers(project, table1Name, table2Name, csvMatcherFilePath);
    }

    public static Matcher importMatcherFromCSVWithHeader(String programName, Project project, Table table1, Table table2, String programFilePath) throws IOException {
        return ParsingUtils.readMatcher(programName, project, table1, table2, programFilePath);
    }

    public static void addFunction(String projectName, String functionName, String functionDesc, String functionClassName, boolean saveToDisk) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        Class<?> functionClass = Class.forName(functionClassName);
        Constructor<?> constructor = functionClass.getConstructor(String.class, String.class);
        Function function = (Function)constructor.newInstance(functionName, functionDesc);
        Project project = ProjectDao.open(projectName);
        project.addFunction(function);
        if (saveToDisk) {
            FunctionSaver.addFunction(projectName, function);
        } else {
            project.addUnsavedFunction(functionName);
        }
        ProjectDao.updateProject(project);
    }

    public static void saveFunction(String projectName, String functionName) throws SecurityException, IllegalArgumentException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Project project = ProjectDao.open(projectName);
        if (!project.isUnsavedFunction(functionName)) {
            return;
        }
        Function function = project.findFunctionByName(functionName);
        FunctionSaver.saveFunction(projectName, function);
        project.removeUnsavedFunction(functionName);
        ProjectDao.updateProject(project);
    }

    public static void saveAllFunctions(String projectName) throws IOException {
        Project project = ProjectDao.open(projectName);
        if (project.getUnsavedFunctions().isEmpty()) {
            return;
        }
        FunctionSaver.saveAllFunctions(project);
        project.clearUnsavedFunctions();
        ProjectDao.updateProject(project);
    }

    public static void addFeature(String projectName, String featureName, String functionName, String table1Name, String table2Name, String attr1Name, String attr2Name, boolean saveToDisk) throws IOException {
        Project project = ProjectDao.open(projectName);
        Function function = project.findFunctionByName(functionName);
        Table table1 = TableDao.open(projectName, table1Name);
        Table table2 = TableDao.open(projectName, table2Name);
        Attribute attribute1 = table1.getAttributeByName(attr1Name);
        Attribute attribute2 = table2.getAttributeByName(attr2Name);
        Feature feature = new Feature(featureName, function, projectName, table1Name, table2Name, attribute1, attribute2);
        project.addFeature(feature);
        if (saveToDisk) {
            FeatureSaver.addFeature(projectName, feature);
        } else {
            project.addUnsavedFeature(featureName);
        }
        ProjectDao.updateProject(project);
    }

    public static void saveFeature(String projectName, String featureName) throws IOException {
        Project project = ProjectDao.open(projectName);
        if (!project.isUnsavedFeature(featureName)) {
            return;
        }
        Feature feature = project.findFeatureByName(featureName);
        FeatureSaver.saveFeature(projectName, feature, project);
        project.removeUnsavedFeature(featureName);
        ProjectDao.updateProject(project);
    }

    public static void saveAllFeatures(String projectName) throws IOException {
        Project project = ProjectDao.open(projectName);
        if (project.getUnsavedFeatures().isEmpty()) {
            return;
        }
        FeatureSaver.saveAllFeatures(project);
        project.clearUnsavedFeatures();
        ProjectDao.updateProject(project);
    }

    private static Term getTerm(Project project, String featureName, String opName, String val) {
        Term term = null;
        if (val != null && !val.isEmpty()) {
            float value = Float.parseFloat(val);
            Feature feature = project.findFeatureByName(featureName);
            RelationalOperator op = RelationalOperator.valueOfFromName(opName);
            term = new Term(feature, op, value);
        }
        return term;
    }

    public static void addRule(String projectName, String ruleName, String table1Name, String table2Name, List<String> featureNames, List<String> operators, List<String> values, boolean saveToDisk) throws IOException {
        Project project = ProjectDao.open(projectName);
        ArrayList<Term> terms = new ArrayList<Term>();
        int i = 0;
        while (i < featureNames.size()) {
            Term term = RuleDao.getTerm(project, featureNames.get(i), operators.get(i), values.get(i));
            if (term != null) {
                terms.add(term);
            }
            ++i;
        }
        System.out.println("[RuleDao:addRule] No. of terms: " + terms.size());
        Rule rule = new Rule(ruleName, projectName, table1Name, table2Name, terms);
        System.out.println("[RuleDao:addRule] Rule: " + rule);
        project.addRule(rule);
        if (saveToDisk) {
            RuleSaver.addRule(projectName, rule);
        } else {
            project.addUnsavedRule(ruleName);
        }
        ProjectDao.updateProject(project);
    }

    public static void saveRule(String projectName, String ruleName) throws IOException {
        Project project = ProjectDao.open(projectName);
        if (!project.isUnsavedRule(ruleName)) {
            return;
        }
        Rule rule = project.findRuleByName(ruleName);
        RuleSaver.saveRule(projectName, rule, project);
        project.removeUnsavedRule(ruleName);
        ProjectDao.updateProject(project);
    }

    public static void saveAllRules(String projectName) throws IOException {
        Project project = ProjectDao.open(projectName);
        if (project.getUnsavedRules().isEmpty()) {
            return;
        }
        RuleSaver.saveAllRules(project);
        project.clearUnsavedRules();
        ProjectDao.updateProject(project);
    }

    public static void editFeature(String projectName, String featureName, String featureString, boolean saveToDisk) throws IOException {
        System.out.println("featureName: " + featureName + ", featureString: " + featureString);
        Project project = ProjectDao.open(projectName);
        Feature feature = ParsingUtils.parseFeatureFromDisplayString(project, featureName, featureString);
        System.out.println("[RuleDao:editFeature] Feature: " + feature);
        if (saveToDisk) {
            FeatureSaver.saveFeature(projectName, feature, project);
            project.removeUnsavedFeature(featureName);
        } else {
            project.addUnsavedFeature(featureName);
        }
        ProjectDao.updateProject(project);
    }

    public static void editRule(String projectName, String ruleName, String ruleString, boolean saveToDisk) throws IOException {
        System.out.println("ruleName: " + ruleName + ", ruleString: " + ruleString);
        Project project = ProjectDao.open(projectName);
        Rule rule = project.findRuleByName(ruleName);
        List<Term> terms = ParsingUtils.parseRuleFromDisplayString(project, ruleString);
        rule.setTerms(terms);
        System.out.println("[RuleDao:editRule] Rule: " + rule);
        if (saveToDisk) {
            RuleSaver.saveRule(projectName, rule, project);
            project.removeUnsavedRule(ruleName);
        } else {
            project.addUnsavedRule(ruleName);
        }
        ProjectDao.updateProject(project);
    }

    public static void editMatcher(String projectName, String matcherName, String matcherString, boolean saveToDisk) throws IOException {
        System.out.println("matcherName: " + matcherName + ", matcherString: " + matcherString);
        Project project = ProjectDao.open(projectName);
        Matcher matcher = ParsingUtils.parseMatcherFromDisplayString(project, matcherName, matcherString, saveToDisk);
        System.out.println("[RuleDao:editMatcher] Matcher: " + matcher);
        if (saveToDisk) {
            MatcherSaver.saveMatcher(projectName, matcher, project);
            project.removeUnsavedMatcher(matcherName);
        } else {
            project.addUnsavedMatcher(matcherName);
        }
        ProjectDao.updateProject(project);
    }

    private static Rule getRule(Project project, String ruleName) {
        Rule rule = null;
        if (ruleName != null && !ruleName.isEmpty()) {
            rule = project.findRuleByName(ruleName);
        }
        return rule;
    }

    public static void addMatcher(String projectName, String matcherName, String table1Name, String table2Name, String rule1Name, String rule2Name, String rule3Name, String rule4Name, String rule5Name, boolean saveToDisk) throws IOException {
        Rule rule5;
        Rule rule4;
        Rule rule3;
        Rule rule2;
        Project project = ProjectDao.open(projectName);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule1 = RuleDao.getRule(project, rule1Name);
        if (rule1 != null) {
            rules.add(rule1);
        }
        if ((rule2 = RuleDao.getRule(project, rule2Name)) != null) {
            rules.add(rule2);
        }
        if ((rule3 = RuleDao.getRule(project, rule3Name)) != null) {
            rules.add(rule3);
        }
        if ((rule4 = RuleDao.getRule(project, rule4Name)) != null) {
            rules.add(rule4);
        }
        if ((rule5 = RuleDao.getRule(project, rule5Name)) != null) {
            rules.add(rule5);
        }
        Matcher matcher = new Matcher(matcherName, projectName, table1Name, table2Name, rules);
        project.addMatcher(matcher);
        if (saveToDisk) {
            MatcherSaver.addMatcher(projectName, matcher);
        } else {
            project.addUnsavedMatcher(matcherName);
        }
        ProjectDao.updateProject(project);
    }

    public static void saveMatcher(String projectName, String matcherName) throws IOException {
        Project project = ProjectDao.open(projectName);
        if (!project.isUnsavedMatcher(matcherName)) {
            return;
        }
        Matcher matcher = project.findMatcherByName(matcherName);
        MatcherSaver.saveMatcher(projectName, matcher, project);
        project.removeUnsavedMatcher(matcherName);
        ProjectDao.updateProject(project);
    }

    public static void saveAllMatchers(String projectName) throws IOException {
        Project project = ProjectDao.open(projectName);
        if (project.getUnsavedMatchers().isEmpty()) {
            return;
        }
        MatcherSaver.saveAllMatchers(project);
        project.clearUnsavedMatchers();
        ProjectDao.updateProject(project);
    }

    public static List<Function> importFunctions(String projectName, String csvFunctionFilePath, boolean saveToDisk) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Project project = ProjectDao.open(projectName);
        return RuleDao.importFunctions(project, csvFunctionFilePath, saveToDisk);
    }

    public static List<Function> importFunctions(Project project, String csvFunctionFilePath, boolean saveToDisk) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        List<Function> functions = CSVUtils.loadFunctions(csvFunctionFilePath);
        project.addFunctions(functions);
        if (saveToDisk) {
            FunctionSaver.addFunctions(project.getName(), functions);
        } else {
            for (Function function : functions) {
                project.addUnsavedFunction(function.getName());
            }
        }
        ProjectDao.updateProject(project);
        return functions;
    }

    public static void save(String projectName, List<Feature> features) throws IOException {
        Project project = ProjectDao.open(projectName);
        project.addFeatures(features);
        ProjectDao.save(project);
    }

    public static void saveRules(String projectName, List<Rule> rules) throws IOException {
        Project project = ProjectDao.open(projectName);
        project.addRules(rules);
        ProjectDao.save(project);
    }

    public static void saveMatchers(String projectName, List<Matcher> matchers) throws IOException {
        Project project = ProjectDao.open(projectName);
        project.addMatchers(matchers);
        ProjectDao.save(project);
    }

    public static void save(String projectName, Matcher program) throws IOException {
        Project project = ProjectDao.open(projectName);
        project.addMatcher(program);
        ProjectDao.save(project);
    }

    public static String getRuleString(String projectName, String ruleName) {
        Project project = ProjectDao.open(projectName);
        Rule rule = project.findRuleByName(ruleName);
        return rule.getDisplayString();
    }

    public static String getMatcherString(String projectName, String matcherName) {
        Project project = ProjectDao.open(projectName);
        Matcher matcher = project.findMatcherByName(matcherName);
        return matcher.getDisplayString();
    }

    public static String getFeatureString(String projectName, String featureName) {
        Project project = ProjectDao.open(projectName);
        Feature feature = project.findFeatureByName(featureName);
        return feature.getDisplayString();
    }
}

