/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.daos;

import com.walmart.productgenome.matching.daos.ProjectDao;
import com.walmart.productgenome.matching.models.DefaultType;
import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.loaders.CSVLoader;
import com.walmart.productgenome.matching.models.loaders.TableLoader;
import com.walmart.productgenome.matching.models.savers.TableSaver;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableDao {
    private static Map<String, List<String>> projectTableMap = new HashMap<String, List<String>>();
    private static Map<String, Map<String, Table>> tableCache = new HashMap<String, Map<String, Table>>();

    static {
        List<Project> projects = ProjectDao.findAll();
        for (Project p : projects) {
            projectTableMap.put(p.getName(), p.getTableNames());
            tableCache.put(p.getName(), new HashMap());
        }
    }

    public static List<String> listTableNames(String projectName) {
        return projectTableMap.get(projectName);
    }

    public static Table open(String projectName, String tableName) throws IOException {
        List<String> tableNames = projectTableMap.get(projectName);
        if (!tableNames.contains(tableName)) {
            return null;
        }
        Map<String, Table> tableMap = tableCache.get(projectName);
        Table table = tableMap.get(tableName);
        if (table == null) {
            System.out.println("Loading Project " + projectName + " -> Table " + tableName + " from disk");
            String tableFilePath = "./ems/" + projectName + "/" + tableName + ".table";
            table = TableLoader.loadTable(tableFilePath);
            tableMap.put(tableName, table);
            tableCache.put(projectName, tableMap);
        }
        return table;
    }

    public static boolean delete(Table table) throws IOException {
        String tableName = table.getName();
        String projectName = table.getProjectName();
        boolean success = false;
        File tableFile = new File("./ems/" + projectName + "/" + tableName + ".table");
        success = tableFile.delete();
        if (!success) {
            return success;
        }
        Project project = ProjectDao.open(projectName);
        success = project.deleteTableName(tableName);
        ProjectDao.save(project);
        projectTableMap.put(projectName, project.getTableNames());
        Map<String, Table> tableMap = tableCache.get(projectName);
        tableMap.remove(tableName);
        tableCache.put(projectName, tableMap);
        return success;
    }

    public static void saveTable(String projectName, String tableName) {
        Project project = ProjectDao.open(projectName);
        if (!project.isUnsavedTable(tableName)) {
            return;
        }
        Table table = tableCache.get(projectName).get(tableName);
        TableSaver.saveTable(table);
        project.removeUnsavedTable(tableName);
        ProjectDao.updateProject(project);
    }

    public static int saveAllTables(String projectName) {
        Project project = ProjectDao.open(projectName);
        Set<String> unsavedTableNames = project.getUnsavedTables();
        for (String tableName : unsavedTableNames) {
            Table table = tableCache.get(projectName).get(tableName);
            TableSaver.saveTable(table);
            project.removeUnsavedTable(tableName);
        }
        ProjectDao.updateProject(project);
        return unsavedTableNames.size();
    }

    public static void save(Table table, Set<DefaultType> defaultTypes, boolean saveToDisk) throws IOException {
        String projectName = table.getProjectName();
        String tableName = table.getName();
        Project project = ProjectDao.open(projectName);
        project.addTableName(tableName);
        for (DefaultType defaultType : defaultTypes) {
            switch (defaultType) {
                case TABLE1: {
                    project.setDefaultTable1(tableName);
                    break;
                }
                case TABLE2: {
                    project.setDefaultTable2(tableName);
                    break;
                }
                case CAND_SET: {
                    project.setDefaultCandset(tableName);
                    break;
                }
                case MATCHES: {
                    project.setDefaultMatches(tableName);
                    break;
                }
                case GOLD: {
                    project.setDefaultGold(tableName);
                    break;
                }
            }
        }
        projectTableMap.put(projectName, project.getTableNames());
        Map<String, Table> tableMap = tableCache.get(projectName);
        if (tableMap == null) {
            tableMap = new HashMap<String, Table>();
        }
        tableMap.put(tableName, table);
        tableCache.put(projectName, tableMap);
        if (saveToDisk) {
            TableSaver.saveTable(table);
        } else {
            project.addUnsavedTable(tableName);
        }
        ProjectDao.updateProject(project);
    }

    public static Table importFromCSVWithHeader(String projectName, String tableName, String csvFilePath) throws IOException {
        return CSVLoader.loadTableFromCSVWithHeaderAsSchema(projectName, tableName, csvFilePath);
    }

    public static Table importFromCSV(String projectName, String tableName, String csvFilePath, Attribute idAttrib, List<Attribute> attributes) throws IOException {
        return CSVLoader.loadTableFromCSV(projectName, tableName, csvFilePath, idAttrib, attributes);
    }

    public static Table importTable(String projectName, String tableName, String tableFilePath) throws IOException {
        Table table = TableLoader.loadTable(tableFilePath);
        table.setName(tableName);
        table.setProjectName(projectName);
        return table;
    }
}

