/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.evaluate;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;

public class EvaluationSummary {
    private String name;
    private String projectName;
    private String matchesName;
    private String goldName;
    private float precision = Float.NaN;
    private float recall = Float.NaN;
    private float f1 = Float.NaN;
    private Set<IdPair> actualPositives = new HashSet<IdPair>();
    private Set<IdPair> truePositives = new HashSet<IdPair>();
    private Set<IdPair> falsePositives = new HashSet<IdPair>();

    public EvaluationSummary(String name, String projectName, String matchesName, String goldName) {
        this.name = name;
        this.projectName = projectName;
        this.matchesName = matchesName;
        this.goldName = goldName;
    }

    public void computeAccuracyEstimates() {
        int numTruePositives = this.truePositives.size();
        int numFalsePositives = this.falsePositives.size();
        int numActualPositives = this.actualPositives.size();
        int numPredictedPositives = numTruePositives + numFalsePositives;
        if (numActualPositives != 0) {
            this.precision = 1.0f * (float)numTruePositives / (float)numPredictedPositives;
            this.recall = 1.0f * (float)numTruePositives / (float)numActualPositives;
        }
        if (this.precision == 0.0f && this.recall == 0.0f) {
            this.f1 = 0.0f;
        } else if (this.precision != Float.NaN && this.recall != Float.NaN) {
            this.f1 = 2.0f * this.precision * this.recall / (this.precision + this.recall);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getMatchesName() {
        return this.matchesName;
    }

    public String getGoldName() {
        return this.goldName;
    }

    public float getPrecision() {
        return this.precision;
    }

    public float getRecall() {
        return this.recall;
    }

    public float getF1() {
        return this.f1;
    }

    public Set<IdPair> getActualPositives() {
        return this.actualPositives;
    }

    public Set<IdPair> getTruePositives() {
        return this.truePositives;
    }

    public Set<IdPair> getFalsePositives() {
        return this.falsePositives;
    }

    public Set<IdPair> getFalseNegatives() {
        HashSet<IdPair> falseNegatives = new HashSet<IdPair>();
        for (IdPair idPair : this.actualPositives) {
            if (this.truePositives.contains(idPair)) continue;
            falseNegatives.add(idPair);
        }
        return falseNegatives;
    }

    public void addActualPositive(IdPair idPair) {
        this.actualPositives.add(idPair);
    }

    public void addTruePositive(IdPair idPair) {
        this.truePositives.add(idPair);
    }

    public void addFalsePositive(IdPair idPair) {
        this.falsePositives.add(idPair);
    }

    public void setPrecision(float precision) {
        this.precision = precision;
    }

    public void setRecall(float recall) {
        this.recall = recall;
    }

    public void setF1(float f1) {
        this.f1 = f1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Precision: ");
        sb.append(this.precision);
        sb.append(", Recall: ");
        sb.append(this.recall);
        sb.append(", F1: ");
        sb.append(this.f1);
        sb.append(", Actual Positives (in gold): ");
        sb.append(this.actualPositives.size());
        sb.append(", True Positives: ");
        sb.append(this.truePositives.size());
        sb.append(", False Positives: ");
        sb.append(this.falsePositives.size());
        sb.append("]");
        return sb.toString();
    }

    public static class IdPair {
        private Object id1;
        private Object id2;

        public Object getId1() {
            return this.id1;
        }

        public Object getId2() {
            return this.id2;
        }

        public IdPair(Object id1, Object id2) {
            this.id1 = id1;
            this.id2 = id2;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id1, this.id2});
        }

        public boolean equals(Object object) {
            if (object instanceof IdPair) {
                IdPair that = (IdPair)object;
                return Objects.equal((Object)this.id1, (Object)that.id1) && Objects.equal((Object)this.id2, (Object)that.id2);
            }
            return false;
        }
    }
}

