/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models;

import java.util.ArrayList;
import java.util.List;

public enum RelationalOperator {
    EQUALS("=="),
    GREATER_THAN(">"),
    GREATER_THAN_EQUALS(">="),
    LESS_THAN("<"),
    LESS_THAN_EQUALS("<="),
    NOT_EQUALS("!=");

    private String name;

    private RelationalOperator(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static List<String> getOperatorNames() {
        ArrayList<String> operatorNames = new ArrayList<String>();
        RelationalOperator[] relationalOperatorArray = RelationalOperator.values();
        int n = relationalOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationalOperator relop = relationalOperatorArray[n2];
            operatorNames.add(relop.getName());
            ++n2;
        }
        return operatorNames;
    }

    public static RelationalOperator valueOfFromName(String name) {
        if ("==".equals(name)) {
            return EQUALS;
        }
        if (">".equals(name)) {
            return GREATER_THAN;
        }
        if (">=".equals(name)) {
            return GREATER_THAN_EQUALS;
        }
        if ("<".equals(name)) {
            return LESS_THAN;
        }
        if ("<=".equals(name)) {
            return LESS_THAN_EQUALS;
        }
        if ("!=".equals(name)) {
            return NOT_EQUALS;
        }
        throw new IllegalArgumentException("Invalid relational operator");
    }
}

