/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.data;

import com.google.common.base.Objects;

public class Attribute {
    private String name;
    private Type type;

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Attribute(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public void typeCheck(Object attributeValue) throws IllegalArgumentException {
        switch (this.type) {
            case TEXT: {
                if (attributeValue instanceof String) break;
                throw new IllegalArgumentException("Attribute Type violation: String value expected for " + attributeValue);
            }
            case INTEGER: {
                if (attributeValue instanceof Integer) break;
                throw new IllegalArgumentException("Attribute Type violation: Integer value expected for " + attributeValue);
            }
            case LONG: {
                if (attributeValue instanceof Long) break;
                throw new IllegalArgumentException("Attribute Type violation: Long value expected for " + attributeValue);
            }
            case FLOAT: {
                if (attributeValue instanceof Float) break;
                throw new IllegalArgumentException("Attribute Type violation: Float value expected for " + attributeValue);
            }
            case BOOLEAN: {
                if (attributeValue instanceof Boolean) break;
                throw new IllegalArgumentException("Attribute Type violation: Boolean value expected for " + attributeValue);
            }
            default: {
                throw new IllegalArgumentException("Attribute Type violation: Text/Integer/Long/Float/Boolean value expected for " + attributeValue);
            }
        }
    }

    public Object convertValueToObject(String val) {
        if (val == null || val.isEmpty()) {
            return null;
        }
        Object value = null;
        switch (this.type) {
            case TEXT: {
                value = val;
                break;
            }
            case INTEGER: {
                try {
                    value = Integer.parseInt(val);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Attribute Type violation: Integer value expected for " + val);
                }
            }
            case LONG: {
                try {
                    value = Long.parseLong(val);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Attribute Type violation: Long value expected for " + val);
                }
            }
            case FLOAT: {
                try {
                    value = Float.valueOf(Float.parseFloat(val));
                    break;
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    throw new IllegalArgumentException("Attribute Type violation: Float value expected for " + val);
                }
            }
            case BOOLEAN: {
                if ("true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val)) {
                    value = Boolean.valueOf(val);
                    break;
                }
                throw new IllegalArgumentException("Attribute Type violation: Boolean value expected for " + val);
            }
            default: {
                throw new IllegalArgumentException("Attribute Type violation: Text/Integer/Long/Float/Boolean value expected for " + val);
            }
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.name);
        sb.append(", ");
        sb.append((Object)this.type);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type});
    }

    public boolean equals(Object object) {
        if (object instanceof Attribute) {
            Attribute that = (Attribute)object;
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type));
        }
        return false;
    }

    public static enum Type {
        TEXT,
        INTEGER,
        LONG,
        FLOAT,
        BOOLEAN;

    }
}

