/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.data;

import com.walmart.productgenome.matching.evaluate.EvaluationSummary;
import com.walmart.productgenome.matching.models.data.ProjectDefaults;
import com.walmart.productgenome.matching.models.rules.Feature;
import com.walmart.productgenome.matching.models.rules.Matcher;
import com.walmart.productgenome.matching.models.rules.Rule;
import com.walmart.productgenome.matching.models.rules.functions.Function;
import com.walmart.productgenome.matching.service.debug.MatchingSummary;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Project {
    private static final DateFormat formatter = new SimpleDateFormat();
    private String name;
    private String description;
    private Date createdOn = new Date();
    private Date lastModifiedOn = new Date();
    private ProjectDefaults defaults = new ProjectDefaults();
    private Set<String> tableNames = new LinkedHashSet<String>();
    private Map<String, Function> functionMap = new LinkedHashMap<String, Function>();
    private Map<String, Feature> featureMap = new LinkedHashMap<String, Feature>();
    private Map<String, Rule> ruleMap = new LinkedHashMap<String, Rule>();
    private Map<String, Matcher> matcherMap = new LinkedHashMap<String, Matcher>();
    private Map<String, MatchingSummary> matchingSummaryMap = new LinkedHashMap<String, MatchingSummary>();
    private Map<String, EvaluationSummary> evaluationSummaryMap = new LinkedHashMap<String, EvaluationSummary>();
    private Set<String> unsavedTables = new HashSet<String>();
    private Set<String> unsavedFunctions = new HashSet<String>();
    private Set<String> unsavedFeatures = new HashSet<String>();
    private Set<String> unsavedRules = new HashSet<String>();
    private Set<String> unsavedMatchers = new HashSet<String>();

    public Project() {
    }

    public Project(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public String getCreatedOnString() {
        return formatter.format(this.createdOn);
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public String getLastModifiedOnString() {
        return formatter.format(this.lastModifiedOn);
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public void setCreatedOn(String createdOn) throws ParseException {
        this.createdOn = formatter.parse(createdOn);
    }

    public void setLastModifiedOn(String lastModifiedOn) throws ParseException {
        this.lastModifiedOn = formatter.parse(lastModifiedOn);
    }

    public List<String> getTableNames() {
        return new ArrayList<String>(this.tableNames);
    }

    public void addTableNames(Collection<String> tableNames) {
        this.tableNames.addAll(tableNames);
    }

    public void addTableName(String tableName) {
        this.tableNames.add(tableName);
    }

    public boolean deleteTableName(String tableName) {
        return this.tableNames.remove(tableName);
    }

    public List<Function> getFunctions() {
        return new ArrayList<Function>(this.functionMap.values());
    }

    public List<String> getFunctionNames() {
        return new ArrayList<String>(this.functionMap.keySet());
    }

    public void addFunctions(Collection<Function> functions) {
        for (Function f : functions) {
            this.functionMap.put(f.getName(), f);
        }
    }

    public void addFunction(Function function) {
        this.functionMap.put(function.getName(), function);
    }

    public boolean deleteFunction(Function function) {
        this.functionMap.remove(function.getName());
        return true;
    }

    public Function findFunctionByName(String functionName) {
        return this.functionMap.get(functionName);
    }

    public List<Feature> getFeatures() {
        return new ArrayList<Feature>(this.featureMap.values());
    }

    public List<String> getFeatureNames() {
        return new ArrayList<String>(this.featureMap.keySet());
    }

    public void addFeatures(Collection<Feature> features) {
        for (Feature f : features) {
            this.featureMap.put(f.getName(), f);
        }
    }

    public void addFeature(Feature feature) {
        this.featureMap.put(feature.getName(), feature);
    }

    public boolean deleteFeature(Feature feature) {
        this.featureMap.remove(feature.getName());
        return true;
    }

    public Feature findFeatureByName(String featureName) {
        return this.featureMap.get(featureName);
    }

    public List<Rule> getRules() {
        return new ArrayList<Rule>(this.ruleMap.values());
    }

    public List<String> getRuleNames() {
        return new ArrayList<String>(this.ruleMap.keySet());
    }

    public void addRules(Collection<Rule> rules) {
        for (Rule r : rules) {
            this.ruleMap.put(r.getName(), r);
        }
    }

    public void addRule(Rule rule) {
        this.ruleMap.put(rule.getName(), rule);
    }

    public boolean deleteRule(Rule rule) {
        this.ruleMap.remove(rule.getName());
        return true;
    }

    public Rule findRuleByName(String ruleName) {
        return this.ruleMap.get(ruleName);
    }

    public List<Matcher> getMatchers() {
        return new ArrayList<Matcher>(this.matcherMap.values());
    }

    public List<String> getMatcherNames() {
        return new ArrayList<String>(this.matcherMap.keySet());
    }

    public void addMatchers(Collection<Matcher> matchers) {
        for (Matcher m : matchers) {
            this.matcherMap.put(m.getName(), m);
        }
    }

    public void addMatcher(Matcher matcher) {
        this.matcherMap.put(matcher.getName(), matcher);
    }

    public boolean deleteMatcher(Matcher matcher) {
        this.matcherMap.remove(matcher.getName());
        return true;
    }

    public Matcher findMatcherByName(String matcherName) {
        return this.matcherMap.get(matcherName);
    }

    public List<MatchingSummary> getMatchingSummary() {
        return new ArrayList<MatchingSummary>(this.matchingSummaryMap.values());
    }

    public List<String> getMatchingSummaryNames() {
        return new ArrayList<String>(this.matchingSummaryMap.keySet());
    }

    public void addMatchingSummaries(Collection<MatchingSummary> matchingSummaries) {
        for (MatchingSummary ms : matchingSummaries) {
            this.matchingSummaryMap.put(ms.getName(), ms);
        }
    }

    public void addMatchingSummary(MatchingSummary matchingSummary) {
        this.matchingSummaryMap.put(matchingSummary.getName(), matchingSummary);
    }

    public boolean deleteMatchingSummary(MatchingSummary matchingSummary) {
        this.matchingSummaryMap.remove(matchingSummary.getName());
        return true;
    }

    public MatchingSummary findMatchingSummaryByName(String matchingSummaryName) {
        return this.matchingSummaryMap.get(matchingSummaryName);
    }

    public List<EvaluationSummary> getEvaluationSummary() {
        return new ArrayList<EvaluationSummary>(this.evaluationSummaryMap.values());
    }

    public List<String> getEvaluationSummaryNames() {
        return new ArrayList<String>(this.evaluationSummaryMap.keySet());
    }

    public void addEvaluationSummaries(Collection<EvaluationSummary> evaluationSummaries) {
        for (EvaluationSummary es : evaluationSummaries) {
            this.evaluationSummaryMap.put(es.getName(), es);
        }
    }

    public void addEvaluationSummary(EvaluationSummary evaluationSummary) {
        this.evaluationSummaryMap.put(evaluationSummary.getName(), evaluationSummary);
    }

    public boolean deleteEvaluationSummary(EvaluationSummary evaluationSummary) {
        this.evaluationSummaryMap.remove(evaluationSummary.getName());
        return true;
    }

    public EvaluationSummary findEvaluationSummaryByName(String evaluationSummaryName) {
        return this.evaluationSummaryMap.get(evaluationSummaryName);
    }

    public String getDefaultTable1() {
        return this.defaults.getDefaultTable1();
    }

    public void setDefaultTable1(String defaultTable1) {
        this.defaults.setDefaultTable1(defaultTable1);
    }

    public String getDefaultTable2() {
        return this.defaults.getDefaultTable2();
    }

    public void setDefaultTable2(String defaultTable2) {
        this.defaults.setDefaultTable2(defaultTable2);
    }

    public String getDefaultCandset() {
        return this.defaults.getDefaultCandset();
    }

    public void setDefaultCandset(String defaultCandset) {
        this.defaults.setDefaultCandset(defaultCandset);
    }

    public String getDefaultMatches() {
        return this.defaults.getDefaultMatches();
    }

    public void setDefaultMatches(String defaultMatches) {
        this.defaults.setDefaultMatches(defaultMatches);
    }

    public String getDefaultGold() {
        return this.defaults.getDefaultGold();
    }

    public void setDefaultGold(String defaultGold) {
        this.defaults.setDefaultGold(defaultGold);
    }

    public Set<String> getUnsavedTables() {
        return this.unsavedTables;
    }

    public Set<String> getUnsavedFunctions() {
        return this.unsavedFunctions;
    }

    public Set<String> getUnsavedFeatures() {
        return this.unsavedFeatures;
    }

    public Set<String> getUnsavedRules() {
        return this.unsavedRules;
    }

    public Set<String> getUnsavedMatchers() {
        return this.unsavedMatchers;
    }

    public boolean hasUnsavedArtifacts() {
        return !this.unsavedTables.isEmpty() || !this.unsavedFunctions.isEmpty() || !this.unsavedFeatures.isEmpty() || !this.unsavedRules.isEmpty() || !this.unsavedMatchers.isEmpty();
    }

    public void addUnsavedTable(String tableName) {
        this.unsavedTables.add(tableName);
    }

    public boolean isUnsavedTable(String tableName) {
        return this.unsavedTables.contains(tableName);
    }

    public void removeUnsavedTable(String tableName) {
        this.unsavedTables.remove(tableName);
    }

    public void addUnsavedFunction(String functionName) {
        this.unsavedFunctions.add(functionName);
    }

    public boolean isUnsavedFunction(String functionName) {
        return this.unsavedFunctions.contains(functionName);
    }

    public void removeUnsavedFunction(String functionName) {
        this.unsavedFunctions.remove(functionName);
    }

    public void clearUnsavedFunctions() {
        this.unsavedFunctions.clear();
    }

    public void addUnsavedFeature(String featureName) {
        this.unsavedFeatures.add(featureName);
    }

    public boolean isUnsavedFeature(String featureName) {
        return this.unsavedFeatures.contains(featureName);
    }

    public void removeUnsavedFeature(String featureName) {
        this.unsavedFeatures.remove(featureName);
    }

    public void clearUnsavedFeatures() {
        this.unsavedFeatures.clear();
    }

    public void addUnsavedRule(String ruleName) {
        this.unsavedRules.add(ruleName);
    }

    public boolean isUnsavedRule(String ruleName) {
        return this.unsavedRules.contains(ruleName);
    }

    public void removeUnsavedRule(String ruleName) {
        this.unsavedRules.remove(ruleName);
    }

    public void clearUnsavedRules() {
        this.unsavedRules.clear();
    }

    public void addUnsavedMatcher(String matcherName) {
        this.unsavedMatchers.add(matcherName);
    }

    public boolean isUnsavedMatcher(String matcherName) {
        return this.unsavedMatchers.contains(matcherName);
    }

    public void removeUnsavedMatcher(String matcherName) {
        this.unsavedMatchers.remove(matcherName);
    }

    public void clearUnsavedMatchers() {
        this.unsavedMatchers.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.name);
        sb.append(",");
        sb.append(this.description);
        sb.append(",");
        sb.append(this.createdOn);
        sb.append(",");
        sb.append(this.lastModifiedOn);
        sb.append("]");
        return sb.toString();
    }

    public ProjectDefaults getUserSetDefaults() {
        return this.defaults;
    }

    public void setUserSetDefaults(ProjectDefaults userSetDefaults) {
        this.defaults = userSetDefaults;
    }
}

