/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.data;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.utils.JSONUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Table {
    private String name;
    private String description = "";
    private Attribute idAttrib;
    private List<Attribute> attributes;
    private Map<Object, Tuple> tuples;
    private String projectName;

    public Table(String name, Attribute idAttrib, List<Attribute> attributes, String projectName) {
        this.name = name;
        this.idAttrib = idAttrib;
        this.attributes = new ArrayList<Attribute>(attributes);
        this.tuples = new LinkedHashMap<Object, Tuple>();
        this.projectName = projectName;
    }

    public Table(String name, Attribute idAttrib, List<Attribute> attributes, List<Tuple> tuples, String projectName) {
        this(name, idAttrib, attributes, projectName);
        this.addAllTuples(tuples);
    }

    public Table(Table otherTable) {
        this.name = otherTable.getName();
        this.idAttrib = new Attribute(otherTable.getIdAttribute().getName(), otherTable.getIdAttribute().getType());
        this.attributes = new ArrayList<Attribute>(otherTable.getAttributes());
        this.tuples = new LinkedHashMap<Object, Tuple>(otherTable.tuples);
        this.projectName = otherTable.getProjectName();
    }

    public Table(Table otherTable, String tableName, List<Object> ids) {
        this.name = tableName;
        this.idAttrib = new Attribute(otherTable.getIdAttribute().getName(), otherTable.getIdAttribute().getType());
        this.attributes = new ArrayList<Attribute>(otherTable.getAttributes());
        this.tuples = new LinkedHashMap<Object, Tuple>();
        for (Object id : ids) {
            this.tuples.put(id, otherTable.getTuple(id));
        }
        this.projectName = otherTable.getProjectName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Attribute getIdAttribute() {
        return this.idAttrib;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Tuple getTuple(Object id) {
        return this.tuples.get(id);
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void addTuple(Tuple tuple) {
        Object tupleId = tuple.getAttributeValue(this.idAttrib);
        this.tuples.put(tupleId, tuple);
    }

    public void addAllTuples(Collection<Tuple> tuples) {
        for (Tuple tuple : tuples) {
            this.addTuple(tuple);
        }
    }

    public void removeTuple(Object id) {
        this.tuples.remove(id);
    }

    public boolean contains(Tuple tuple) {
        Object tupleId = tuple.getAttributeValue(this.idAttrib);
        return this.tuples.containsKey(tupleId);
    }

    public boolean isEmpty() {
        return this.tuples.isEmpty();
    }

    public long getSize() {
        return this.tuples.size();
    }

    public Collection<Tuple> getAllTuples() {
        return this.tuples.values();
    }

    public List<Tuple> getAllTuplesInOrder() {
        ArrayList<Tuple> tupleList = new ArrayList<Tuple>();
        for (Tuple tuple : this.tuples.values()) {
            tupleList.add(tuple);
        }
        return tupleList;
    }

    public List<Object> getAllIdsInOrder() {
        ArrayList<Object> ids = new ArrayList<Object>(this.tuples.keySet());
        return ids;
    }

    public void clear() {
        this.tuples.clear();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<Object> getAllValuesForAttribute(Attribute attribute) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Tuple tuple : this.tuples.values()) {
            Object val = tuple.getAttributeValue(attribute);
            values.add(val);
        }
        return values;
    }

    public Attribute getAttributeByName(String attrName) {
        for (Attribute attr : this.attributes) {
            if (!attrName.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public List<Object> sortTableByAttribute(List<Object> ids, Attribute attr, boolean ascending) {
        Collections.sort(ids, new AttrComparator(attr));
        if (!ascending) {
            Collections.reverse(ids);
        }
        return ids;
    }

    public List<Object> getAllRowIdsWithAttrValue(Attribute attr, Object value) {
        attr.typeCheck(value);
        ArrayList<Object> ids = new ArrayList<Object>();
        String strValue = String.valueOf(value);
        for (Tuple tuple : this.tuples.values()) {
            String tupleVal = String.valueOf(tuple.getAttributeValue(attr));
            if (!tupleVal.contains(strValue)) continue;
            ids.add(tuple.getAttributeValue(this.idAttrib));
        }
        return ids;
    }

    public List<Object> sortTableByAttribute(List<Object> ids, Attribute attr, Boolean ascending) {
        Collections.sort(ids, new AttrComparator(attr));
        if (!ascending.booleanValue()) {
            Collections.reverse(ids);
        }
        return ids;
    }

    public List<Object> getAllRowsWithQueryCondition(List<Attribute> attrs, List<Object> values, List<QueryOps> ops) {
        ArrayList<Object> ids = new ArrayList<Object>();
        for (Tuple tuple : this.tuples.values()) {
            Boolean matches = true;
            int i = 0;
            while (i < attrs.size()) {
                QueryOps op;
                Object value;
                Attribute attr = attrs.get(i);
                if (!this.meetsQueryCondition(tuple, attr, value = values.get(i), op = ops.get(i)).booleanValue()) {
                    matches = false;
                    break;
                }
                ++i;
            }
            if (!matches.booleanValue()) continue;
            ids.add(tuple.getAttributeValue(this.getIdAttribute()));
        }
        return ids;
    }

    private Boolean meetsQueryCondition(Tuple tuple, Attribute attr, Object value, QueryOps op) {
        Object itemVal = tuple.getAttributeValue(attr);
        if (itemVal == null) {
            return false;
        }
        if (Table.compareUsingOps(attr.getType(), op, itemVal, value).booleanValue()) {
            return true;
        }
        return false;
    }

    public static Boolean compareUsingOps(Attribute.Type type, QueryOps op, Object val1, Object val2) {
        switch (op) {
            case GREATER_THAN: {
                if (Table.customCompareTo(val1, val2) == 1) {
                    return true;
                }
                return false;
            }
            case LESS_THAN: {
                if (Table.customCompareTo(val1, val2) == -1) {
                    return true;
                }
                return false;
            }
            case EQUALS: {
                if (Table.customCompareTo(val1, val2) == 0) {
                    return true;
                }
                return false;
            }
            case GREATER_THAN_EQUALS: {
                if (Table.customCompareTo(val1, val2) != 0 && Table.customCompareTo(val1, val2) != 1) {
                    return false;
                }
                return true;
            }
            case LESS_THAN_EQUALS: {
                if (Table.customCompareTo(val1, val2) != 0 && Table.customCompareTo(val1, val2) != -1) {
                    return false;
                }
                return true;
            }
            case CONTAINS: {
                String sval1 = String.valueOf(val1);
                String sval2 = String.valueOf(val2);
                return sval1.contains(sval2);
            }
        }
        return null;
    }

    private static int customCompareTo(Object val1, Object val2) {
        if (val1 instanceof String && val2 instanceof String) {
            return ((String)val1).compareTo((String)val2);
        }
        if (val1 instanceof Integer && val2 instanceof Integer) {
            return ((Integer)val1).compareTo((Integer)val2);
        }
        if (val1 instanceof Float && val2 instanceof Float) {
            return ((Float)val1).compareTo((Float)val2);
        }
        if (val1 instanceof Boolean && val2 instanceof Boolean) {
            return ((Boolean)val1).compareTo((Boolean)val2);
        }
        throw new IllegalArgumentException("Incompatible objects: Values to be compared are not compatible.");
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> getRandomSample(Long sampleSize) {
        void var4_5;
        HashSet sample = new HashSet();
        ArrayList<Object> ids = new ArrayList<Object>(this.tuples.keySet());
        Collections.shuffle(ids);
        boolean bl = false;
        while ((long)var4_5 < sampleSize) {
            sample.add(ids.get((int)var4_5));
            ++var4_5;
        }
        for (Object e : ids) {
            if (sample.contains(e)) continue;
            this.tuples.remove(e);
        }
        return new ArrayList<Object>(sample);
    }

    public void removeAttr(Attribute attr) {
        this.attributes.remove(attr);
        for (Tuple tuple : this.tuples.values()) {
            tuple.removeAttr(attr);
        }
    }

    public static void main(String[] args) {
        Attribute idAttrib = new Attribute("id", Attribute.Type.TEXT);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(idAttrib);
        attributes.add(new Attribute("title", Attribute.Type.TEXT));
        attributes.add(new Attribute("price", Attribute.Type.FLOAT));
        Table t = new Table("Bowker", idAttrib, attributes, "Products");
        System.out.println(JSONUtils.getTableJSON(t));
    }

    private class AttrComparator
    implements Comparator<Object> {
        private Attribute attr;

        public AttrComparator(Attribute attr) {
            this.attr = attr;
        }

        @Override
        public int compare(Object id1, Object id2) {
            Object value1 = Table.this.getTuple(id1).getAttributeValue(this.attr);
            Object value2 = Table.this.getTuple(id2).getAttributeValue(this.attr);
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value2 == null && value1 != null) {
                return 1;
            }
            if (value2 == null && value1 == null) {
                return 0;
            }
            switch (this.attr.getType()) {
                case TEXT: {
                    String sval1 = (String)value1;
                    String sval2 = (String)value2;
                    return sval1.compareTo(sval2);
                }
                case INTEGER: {
                    Integer ival1 = (Integer)value1;
                    Integer ival2 = (Integer)value2;
                    return ival1.compareTo(ival2);
                }
                case FLOAT: {
                    Float fval1 = (Float)value1;
                    Float fval2 = (Float)value2;
                    return fval1.compareTo(fval2);
                }
                case BOOLEAN: {
                    Boolean bval1 = (Boolean)value1;
                    Boolean bval2 = (Boolean)value2;
                    return bval1.compareTo(bval2);
                }
            }
            throw new IllegalArgumentException("Attribute Type violation: Text/Integer/Float/Boolean value expected for " + this.attr.getName());
        }
    }

    public static enum QueryOps {
        GREATER_THAN,
        LESS_THAN,
        EQUALS,
        GREATER_THAN_EQUALS,
        LESS_THAN_EQUALS,
        CONTAINS;

    }
}

