/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.data;

import com.google.common.base.Objects;
import com.walmart.productgenome.matching.models.data.Attribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Tuple {
    private Map<Attribute, Object> data = new HashMap<Attribute, Object>();

    public Tuple() {
    }

    public Tuple(Map<Attribute, Object> data) throws IllegalArgumentException {
        this();
        for (Map.Entry<Attribute, Object> entry : data.entrySet()) {
            this.setAttributeValue(entry.getKey(), entry.getValue());
        }
    }

    public Object getAttributeValue(Attribute attribute) {
        return this.data.get(attribute);
    }

    public void setAttributeValue(Attribute attribute, Object attributeValue) throws IllegalArgumentException {
        Object attributeValueObj = null;
        if (attributeValue != null) {
            if (attributeValue instanceof String && !((String)attributeValue).isEmpty()) {
                attributeValueObj = attribute.convertValueToObject((String)attributeValue);
            }
            if (attributeValueObj != null) {
                attribute.typeCheck(attributeValueObj);
            }
        }
        this.data.put(attribute, attributeValue);
    }

    public void removeAttr(Attribute attr) {
        this.data.remove(attr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<Attribute, Object> entry : this.data.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(1, "Sanjib");
        map.put(2, "SKD");
        map.put(3, "Dada");
        map.put(4, "Topper");
        map.put(5, "Mr. Das");
        map.put(6, "Bebu");
        for (Integer i : map.keySet()) {
            System.out.println(i);
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.data});
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple) {
            Tuple that = (Tuple)object;
            return Objects.equal(this.data, that.data);
        }
        return false;
    }
}

