/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.loaders;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.utils.JSONUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVLoader {
    private static Attribute getAttribute(String attribStr) {
        String[] vals = attribStr.split(":");
        assert (vals.length > 0);
        String attribName = vals[0].trim();
        String attribType = "TEXT";
        if (vals.length > 1) {
            attribType = vals[1].trim();
        }
        return new Attribute(attribName, Attribute.Type.valueOf(attribType));
    }

    public static Table loadTable(String tableFilePath) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(tableFilePath));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("@info")) break;
        }
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.trim().isEmpty()) break;
            sb.append(line);
        }
        String tableJSON = sb.toString();
        Table table = JSONUtils.getTableFromJSON(tableJSON);
        while ((line = br.readLine()) != null) {
            if (line.startsWith("@data")) break;
        }
        line = br.readLine();
        CSVParser parser = new CSVParser((Reader)br, CSVFormat.DEFAULT);
        List records = parser.getRecords();
        br.close();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        int size = records.size();
        List<Attribute> attributes = table.getAttributes();
        int i = 0;
        while (i < size) {
            CSVRecord rec = (CSVRecord)records.get(i);
            HashMap<Attribute, Object> attrValMap = new HashMap<Attribute, Object>();
            int j = 0;
            while (j < attributes.size()) {
                Attribute a = attributes.get(j);
                String value = rec.get(j);
                attrValMap.put(a, a.convertValueToObject(value));
                ++j;
            }
            tuples.add(new Tuple(attrValMap));
            ++i;
        }
        table.addAllTuples(tuples);
        return table;
    }

    public static Table loadTableFromCSVWithHeaderAsSchema(String projectName, String tableName, String csvFilePath) throws IOException {
        FileReader r = new FileReader(csvFilePath);
        CSVParser parser = new CSVParser((Reader)r, CSVFormat.DEFAULT);
        List records = parser.getRecords();
        r.close();
        CSVRecord header = (CSVRecord)records.get(0);
        Attribute idAttrib = CSVLoader.getAttribute(header.get(0));
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(idAttrib);
        int i = 1;
        while (i < header.size()) {
            Attribute a = CSVLoader.getAttribute(header.get(i));
            attributes.add(a);
            ++i;
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        int size = records.size();
        int i2 = 1;
        while (i2 < size) {
            CSVRecord rec = (CSVRecord)records.get(i2);
            HashMap<Attribute, Object> attrValMap = new HashMap<Attribute, Object>();
            int j = 0;
            while (j < attributes.size()) {
                Attribute a = (Attribute)attributes.get(j);
                String value = rec.get(j);
                attrValMap.put(a, a.convertValueToObject(value));
                ++j;
            }
            tuples.add(new Tuple(attrValMap));
            ++i2;
        }
        return new Table(tableName, idAttrib, attributes, tuples, projectName);
    }

    public static Table loadTableFromCSV(String projectName, String tableName, String csvFilePath, Attribute idAttrib, List<Attribute> attributes) throws IOException {
        FileReader r = new FileReader(csvFilePath);
        CSVParser parser = new CSVParser((Reader)r, CSVFormat.DEFAULT);
        List records = parser.getRecords();
        r.close();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        int size = records.size();
        int i = 0;
        while (i < size) {
            CSVRecord rec = (CSVRecord)records.get(i);
            HashMap<Attribute, Object> attrValMap = new HashMap<Attribute, Object>();
            int j = 0;
            while (j < attributes.size()) {
                Attribute a = attributes.get(j);
                String value = rec.get(j);
                attrValMap.put(a, a.convertValueToObject(value));
                ++j;
            }
            tuples.add(new Tuple(attrValMap));
            ++i;
        }
        return new Table(tableName, idAttrib, attributes, tuples, projectName);
    }

    public static void main(String[] args) throws IOException {
        String csvFilePath = "test.csv";
        String projectName = "testing";
        String tableName = "test";
        Table t = CSVLoader.loadTableFromCSVWithHeaderAsSchema(projectName, tableName, csvFilePath);
        System.out.println(JSONUtils.getTableJSON(t));
    }
}

