/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.loaders;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.utils.JSONUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class TableLoader {
    public static Table loadTable(String tableFilePath) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(tableFilePath));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("@info")) break;
        }
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.trim().isEmpty()) break;
            sb.append(line);
        }
        String tableJSON = sb.toString();
        Table table = JSONUtils.getTableFromJSON(tableJSON);
        while ((line = br.readLine()) != null) {
            if (line.startsWith("@data")) break;
        }
        line = br.readLine();
        CSVParser parser = new CSVParser((Reader)br, CSVFormat.DEFAULT);
        List records = parser.getRecords();
        br.close();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        int size = records.size();
        List<Attribute> attributes = table.getAttributes();
        int i = 0;
        while (i < size) {
            CSVRecord rec = (CSVRecord)records.get(i);
            HashMap<Attribute, Object> attrValMap = new HashMap<Attribute, Object>();
            int j = 0;
            while (j < attributes.size()) {
                Attribute a = attributes.get(j);
                String value = rec.get(j);
                attrValMap.put(a, a.convertValueToObject(value));
                ++j;
            }
            tuples.add(new Tuple(attrValMap));
            ++i;
        }
        table.addAllTuples(tuples);
        return table;
    }
}

