/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.loaders;

import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.models.loaders.Loader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class TableLoaderTemp {
    private Reader m_sourceReader = null;
    private TableReader m_TableReader = null;
    private Table m_structure = null;
    private String m_File = null;
    private Loader.Mode retrievalMode = null;

    public String globalInfo() {
        return "Reads a source that is in .table format";
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_TableReader = null;
        this.setRetrievalMode(Loader.Mode.NONE);
        if (this.m_File != null && !new File(this.m_File).isDirectory()) {
            this.setFile(new File(this.m_File));
        }
    }

    public File retrieveFile() {
        return new File(this.m_File);
    }

    public void setFile(File file) throws IOException {
        this.m_File = file.getPath();
    }

    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_sourceReader = new BufferedReader(new InputStreamReader(in));
    }

    public Table getStructure() throws IOException {
        if (this.m_structure == null) {
            if (this.m_sourceReader == null) {
                throw new IOException("No source has been specified");
            }
            try {
                this.m_TableReader = new TableReader(this.m_sourceReader, 1);
                this.m_structure = this.m_TableReader.getStructure();
            }
            catch (Exception ex) {
                throw new IOException("Unable to determine structure as table (Reason: " + ex.toString() + ").");
            }
        }
        return this.m_structure;
    }

    public Table getTable() throws IOException {
        Table table = null;
        try {
            Tuple tuple;
            if (this.m_sourceReader == null) {
                throw new IOException("No source has been specified");
            }
            if (this.getRetrievalMode() == Loader.Mode.INCREMENTAL) {
                throw new IOException("Cannot mix getting tuples in both incremental and batch modes");
            }
            this.setRetrievalMode(Loader.Mode.BATCH);
            if (this.m_structure == null) {
                this.getStructure();
            }
            table = new Table(this.m_structure);
            while ((tuple = this.m_TableReader.readTuple(this.m_structure)) != null) {
                table.addTuple(tuple);
            }
        }
        finally {
            this.m_sourceReader.close();
        }
        return table;
    }

    public Tuple getNextTuple(Table structure) throws IOException {
        this.m_structure = structure;
        if (this.getRetrievalMode() == Loader.Mode.BATCH) {
            throw new IOException("Cannot mix getting tuples in both incremental and batch modes");
        }
        this.setRetrievalMode(Loader.Mode.INCREMENTAL);
        Tuple current = null;
        if (this.m_sourceReader != null) {
            current = this.m_TableReader.readTuple(this.m_structure);
        }
        if (this.m_sourceReader != null && current == null) {
            try {
                this.m_sourceReader.close();
                this.m_sourceReader = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return current;
    }

    public Loader.Mode getRetrievalMode() {
        return this.retrievalMode;
    }

    public void setRetrievalMode(Loader.Mode retrievalMode) {
        this.retrievalMode = retrievalMode;
    }

    public static class TableReader {
        protected Table m_Data;
        protected int m_Lines;

        public TableReader(Reader reader) throws IOException {
            Tuple tuple;
            this.readInfo(1000);
            while ((tuple = this.readTuple(this.m_Data)) != null) {
                this.m_Data.addTuple(tuple);
            }
        }

        public TableReader(Reader reader, int capacity) throws IOException {
            if (capacity < 0) {
                throw new IllegalArgumentException("Capacity has to be positive!");
            }
            this.readInfo(capacity);
        }

        public TableReader(Reader reader, Table template, int lines) throws IOException {
            this(reader, template, lines, 100);
            Tuple tuple;
            while ((tuple = this.readTuple(this.m_Data)) != null) {
                this.m_Data.addTuple(tuple);
            }
        }

        public TableReader(Reader reader, Table template, int lines, int capacity) throws IOException {
            this.m_Lines = lines;
        }

        public int getLineNo() {
            return -1;
        }

        public Tuple readTuple(Table structure) throws IOException {
            return this.readTuple(structure, true);
        }

        public Tuple readTuple(Table structure, boolean flag) throws IOException {
            return this.getTuple(structure, flag);
        }

        protected Tuple getTuple(Table structure, boolean flag) throws IOException {
            this.m_Data = structure;
            Tuple tuple = null;
            return tuple;
        }

        protected void readInfo(int capacity) throws IOException {
            this.m_Lines = 0;
            String tableName = "";
        }

        public Table getStructure() {
            return new Table(this.m_Data);
        }

        public Table getTable() {
            return this.m_Data;
        }
    }
}

