/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.rules;

import com.walmart.productgenome.matching.models.audit.ItemPairAudit;
import com.walmart.productgenome.matching.models.audit.MatchStatus;
import com.walmart.productgenome.matching.models.audit.RuleAudit;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.models.rules.Rule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Matcher {
    private String name;
    private String projectName;
    private String table1Name;
    private String table2Name;
    private List<Rule> rules;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTable1Name() {
        return this.table1Name;
    }

    public void setTable1Name(String table1Name) {
        this.table1Name = table1Name;
    }

    public String getTable2Name() {
        return this.table2Name;
    }

    public void setTable2Name(String table2Name) {
        this.table2Name = table2Name;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = new ArrayList<Rule>(rules);
    }

    public Matcher(String name, String projectName, String table1Name, String table2Name) {
        this.name = name;
        this.projectName = projectName;
        this.table1Name = table1Name;
        this.table2Name = table2Name;
    }

    public Matcher(String name, String projectName, String table1Name, String table2Name, List<Rule> rules) {
        this.name = name;
        this.projectName = projectName;
        this.table1Name = table1Name;
        this.table2Name = table2Name;
        this.rules = new ArrayList<Rule>(rules);
    }

    public MatchStatus evaluate(Tuple tuple1, Tuple tuple2) throws IOException {
        for (Rule r : this.rules) {
            MatchStatus result = r.evaluate(tuple1, tuple2);
            if (result != MatchStatus.MATCH) continue;
            return result;
        }
        return MatchStatus.NON_MATCH;
    }

    public MatchStatus evaluate(Tuple tuple1, Tuple tuple2, ItemPairAudit itemPairAudit) throws IOException {
        ArrayList<RuleAudit> ruleAudits = new ArrayList<RuleAudit>();
        ArrayList<String> matchingRuleNames = new ArrayList<String>();
        MatchStatus result = MatchStatus.NON_MATCH;
        for (Rule r : this.rules) {
            RuleAudit ruleAudit = new RuleAudit(r);
            MatchStatus rtmp = r.evaluate(tuple1, tuple2, ruleAudit);
            ruleAudit.setStatus(rtmp);
            if (rtmp == MatchStatus.MATCH) {
                matchingRuleNames.add(r.getName());
                result = MatchStatus.MATCH;
            } else if (rtmp != MatchStatus.NON_MATCH && result != MatchStatus.MATCH) {
                result = rtmp;
            }
            ruleAudits.add(ruleAudit);
        }
        itemPairAudit.setMatchingRuleNames(matchingRuleNames);
        itemPairAudit.setRuleAuditValues(ruleAudits);
        return result;
    }

    public int getNumRules() {
        return this.rules.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        int i = 0;
        while (i < this.rules.size()) {
            Rule r = this.rules.get(i);
            sb.append(r.toString());
            if (i != this.rules.size() - 1) {
                sb.append(" OR ");
            }
            ++i;
        }
        return sb.toString();
    }

    public String getShortDisplayString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.rules.size()) {
            Rule r = this.rules.get(i);
            sb.append(r.getName());
            if (i != this.rules.size() - 1) {
                sb.append(" OR ");
            }
            ++i;
        }
        return sb.toString();
    }

    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.rules.size()) {
            Rule r = this.rules.get(i);
            sb.append(r.getDisplayString());
            if (i != this.rules.size() - 1) {
                sb.append(" OR ");
            }
            ++i;
        }
        return sb.toString();
    }
}

