/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.rules;

import com.walmart.productgenome.matching.models.audit.MatchStatus;
import com.walmart.productgenome.matching.models.audit.RuleAudit;
import com.walmart.productgenome.matching.models.audit.TermAudit;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.models.rules.Term;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Rule {
    private String name;
    private String projectName;
    private String table1Name;
    private String table2Name;
    private List<Term> terms;

    public Rule(String name, String projectName, String table1Name, String table2Name, List<Term> terms) {
        this.name = name;
        this.projectName = projectName;
        this.table1Name = table1Name;
        this.table2Name = table2Name;
        this.terms = new ArrayList<Term>(terms);
    }

    public String getName() {
        return this.name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTable1Name() {
        return this.table1Name;
    }

    public String getTable2Name() {
        return this.table2Name;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public void setTerms(List<Term> terms) {
        this.terms = new ArrayList<Term>(terms);
    }

    public MatchStatus evaluate(Tuple tuple1, Tuple tuple2) throws IOException {
        for (Term t : this.terms) {
            MatchStatus result = t.evaluate(tuple1, tuple2);
            if (result == MatchStatus.MATCH) continue;
            return result;
        }
        return MatchStatus.MATCH;
    }

    public MatchStatus evaluate(Tuple tuple1, Tuple tuple2, RuleAudit ruleAudit) throws IOException {
        MatchStatus result = MatchStatus.MATCH;
        ArrayList<TermAudit> termAudits = new ArrayList<TermAudit>();
        for (Term t : this.terms) {
            TermAudit termAudit = new TermAudit(t);
            MatchStatus rtmp = t.evaluate(tuple1, tuple2, termAudit);
            termAudit.setStatus(rtmp);
            if (rtmp == MatchStatus.NON_MATCH) {
                result = rtmp;
            } else if (rtmp != MatchStatus.MATCH && result == MatchStatus.MATCH) {
                result = rtmp;
            }
            termAudits.add(termAudit);
        }
        ruleAudit.setTermAuditValues(termAudits);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.terms.size()) {
            Term t = this.terms.get(i);
            sb.append(t.toString());
            if (i != this.terms.size() - 1) {
                sb.append(" AND ");
            }
            ++i;
        }
        return sb.toString();
    }

    public String getRuleString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.terms.size()) {
            Term t = this.terms.get(i);
            sb.append(t.getTermString());
            if (i != this.terms.size() - 1) {
                sb.append(" AND ");
            }
            ++i;
        }
        return sb.toString();
    }

    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.terms.size()) {
            Term t = this.terms.get(i);
            sb.append(t.getDisplayString());
            if (i != this.terms.size() - 1) {
                sb.append(" AND ");
            }
            ++i;
        }
        return sb.toString();
    }
}

