/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.rules;

import com.walmart.productgenome.matching.models.RelationalOperator;
import com.walmart.productgenome.matching.models.audit.MatchStatus;
import com.walmart.productgenome.matching.models.audit.TermAudit;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.models.rules.Feature;
import java.io.IOException;

public class Term {
    private Feature feature1;
    private RelationalOperator relop;
    private float value;
    private Feature feature2;

    public Term(Feature feature, RelationalOperator relop, float value) {
        this.feature1 = feature;
        this.relop = relop;
        this.value = value;
    }

    public Term(Feature feature1, RelationalOperator relop, Feature feature2) {
        this.feature1 = feature1;
        this.relop = relop;
        this.feature2 = feature2;
    }

    public Feature getFeature1() {
        return this.feature1;
    }

    public Feature getFeature2() {
        return this.feature2;
    }

    public RelationalOperator getRelop() {
        return this.relop;
    }

    public float getValue() {
        return this.value;
    }

    public MatchStatus evaluate(Tuple tuple1, Tuple tuple2) throws IOException {
        float lvalue = this.feature1.compute(tuple1, tuple2);
        float rvalue = this.value;
        if (this.feature2 != null) {
            rvalue = this.feature2.compute(tuple1, tuple2);
        }
        if (lvalue == Float.NaN || rvalue == Float.NaN) {
            return MatchStatus.DECLINE_TO_PREDICT;
        }
        switch (this.relop) {
            case LESS_THAN: {
                if (!(lvalue < rvalue)) break;
                return MatchStatus.MATCH;
            }
            case LESS_THAN_EQUALS: {
                if (!(lvalue <= rvalue)) break;
                return MatchStatus.MATCH;
            }
            case GREATER_THAN: {
                if (!(lvalue > rvalue)) break;
                return MatchStatus.MATCH;
            }
            case GREATER_THAN_EQUALS: {
                if (!(lvalue >= rvalue)) break;
                return MatchStatus.MATCH;
            }
            case EQUALS: {
                if (lvalue != rvalue) break;
                return MatchStatus.MATCH;
            }
        }
        return MatchStatus.NON_MATCH;
    }

    public MatchStatus evaluate(Tuple tuple1, Tuple tuple2, TermAudit termAudit) throws IOException {
        float lvalue = this.feature1.compute(tuple1, tuple2);
        termAudit.setCalculatedScore(lvalue);
        return this.evaluate(tuple1, tuple2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.feature1.getName());
        sb.append(",");
        sb.append(this.relop.getName());
        sb.append(",");
        if (this.feature2 != null) {
            sb.append(this.feature2.getName());
        } else {
            sb.append(this.value);
        }
        return sb.toString();
    }

    public String getTermString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.feature1.getName());
        sb.append(",");
        sb.append(this.relop.name());
        sb.append(",");
        if (this.feature2 != null) {
            sb.append(this.feature2.getName());
        } else {
            sb.append(this.value);
        }
        return sb.toString();
    }

    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.feature1.getName());
        sb.append(" ");
        sb.append(this.relop.getName());
        sb.append(" ");
        if (this.feature2 != null) {
            sb.append(this.feature2.getName());
        } else {
            sb.append(this.value);
        }
        return sb.toString();
    }
}

