/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.rules.functions;

import com.walmart.productgenome.matching.models.rules.functions.Function;

public class ExactMatch
extends Function {
    public static final String NAME = "EXACT_MATCH";
    public static final String DESCRIPTION = "Returns 1 if two strings match otherwise 0";
    public static final int NUM_ARGS = 2;

    public ExactMatch() {
        super(NAME, DESCRIPTION);
    }

    public ExactMatch(String name, String description) {
        super(name, description);
    }

    @Override
    public Object compute(String[] args) throws IllegalArgumentException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected number of arguments: 2");
        }
        Float res = null;
        res = args[0] == null || args[1] == null ? Float.valueOf(0.0f) : (args[0].equals(args[1]) ? Float.valueOf(1.0f) : Float.valueOf(0.0f));
        return res;
    }

    @Override
    public Function.ArgType getArgType() {
        return Function.ArgType.STRING;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(",");
        sb.append(this.getDescription());
        sb.append(",");
        sb.append(this.getClass().getName());
        sb.append(",");
        sb.append(Float.class.getName());
        sb.append(",");
        sb.append(2);
        sb.append(",");
        sb.append(String.class.getName());
        sb.append(",");
        sb.append(String.class.getName());
        return sb.toString();
    }
}

