/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.rules.functions;

import com.walmart.productgenome.matching.models.rules.functions.Function;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaroWinkler;

public class JaroWinklerSimilarityFunction
extends Function {
    public static final String NAME = "JARO_WINKLER_SIMILARITY";
    public static final String DESCRIPTION = "Jaro Winkler similarity";
    public static final int NUM_ARGS = 2;

    public JaroWinklerSimilarityFunction() {
        super(NAME, DESCRIPTION);
    }

    public JaroWinklerSimilarityFunction(String name, String description) {
        super(name, description);
    }

    @Override
    public Float compute(String[] args) throws IllegalArgumentException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected number of arguments: 2");
        }
        if (args[0] == null || args[1] == null) {
            return Float.valueOf(0.0f);
        }
        if (args[0].toLowerCase().equals("null") || args[1].toLowerCase().equals("null")) {
            return Float.valueOf(0.0f);
        }
        if (args[0].isEmpty() || args[1].isEmpty()) {
            return Float.valueOf(0.0f);
        }
        String newArg0 = args[0].toLowerCase();
        String newArg1 = args[1].toLowerCase();
        JaroWinkler metric = new JaroWinkler();
        return Float.valueOf(metric.getSimilarity(newArg0, newArg1));
    }

    @Override
    public Function.ArgType getArgType() {
        return Function.ArgType.STRING;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(",");
        sb.append(this.getDescription());
        sb.append(",");
        sb.append(this.getClass().getName());
        sb.append(",");
        sb.append(Float.class.getName());
        sb.append(",");
        sb.append(2);
        sb.append(",");
        sb.append(String.class.getName());
        sb.append(",");
        sb.append(String.class.getName());
        return sb.toString();
    }
}

