/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.rules.functions;

import com.walmart.productgenome.matching.models.rules.functions.Function;
import uk.ac.shef.wit.simmetrics.similaritymetrics.MatchingCoefficient;

public class MatchingCoefficientFunction
extends Function {
    public static final String NAME = "MATCHING_COEFFICIENT";
    public static final String DESCRIPTION = "Matching coefficient";
    public static final int NUM_ARGS = 2;

    public MatchingCoefficientFunction() {
        super(NAME, DESCRIPTION);
    }

    public MatchingCoefficientFunction(String name, String description) {
        super(name, description);
    }

    @Override
    public Float compute(String[] args) throws IllegalArgumentException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected number of arguments: 2");
        }
        MatchingCoefficient metric = new MatchingCoefficient();
        return Float.valueOf(metric.getSimilarity(args[0], args[1]));
    }

    @Override
    public Function.ArgType getArgType() {
        return Function.ArgType.STRING;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(",");
        sb.append(this.getDescription());
        sb.append(",");
        sb.append(this.getClass().getName());
        sb.append(",");
        sb.append(Float.class.getName());
        sb.append(",");
        sb.append(2);
        sb.append(",");
        sb.append(String.class.getName());
        sb.append(",");
        sb.append(String.class.getName());
        return sb.toString();
    }
}

