/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.rules.functions;

import com.walmart.productgenome.matching.models.rules.functions.Function;
import com.wcohen.ss.MongeElkan;

public class MongeElkanSimilarity
extends Function {
    public static final String NAME = "MONGE_ELKAN";
    public static final String DESCRIPTION = "Normalised Monge Elkan Similarity";
    public static final int NUM_ARGS = 2;

    public MongeElkanSimilarity() {
        super(NAME, DESCRIPTION);
    }

    public MongeElkanSimilarity(String name, String description) {
        super(name, description);
    }

    @Override
    public Object compute(String[] args) throws IllegalArgumentException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected number of arguments: 2");
        }
        MongeElkan me = new MongeElkan();
        me.setScaling(true);
        return Float.valueOf((float)me.score(args[0], args[1]));
    }

    @Override
    public Function.ArgType getArgType() {
        return Function.ArgType.STRING;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(",");
        sb.append(this.getDescription());
        sb.append(",");
        sb.append(this.getClass().getName());
        sb.append(",");
        sb.append(Float.class.getName());
        sb.append(",");
        sb.append(2);
        sb.append(",");
        sb.append(String.class.getName());
        sb.append(",");
        sb.append(String.class.getName());
        return sb.toString();
    }
}

