/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.rules.functions;

import com.walmart.productgenome.matching.models.rules.functions.Function;

public class NormAbsDiff
extends Function {
    public static final String NAME = "NORM_ABS_DIFF";
    public static final String DESCRIPTION = "Normalised Absolute Difference";
    public static final int NUM_ARGS = 2;

    public NormAbsDiff() {
        super(NAME, DESCRIPTION);
    }

    public NormAbsDiff(String name, String description) {
        super(name, description);
    }

    @Override
    public Float compute(String[] args) throws IllegalArgumentException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected number of arguments: 2");
        }
        if (args[0] == null || args[1] == null) {
            return Float.valueOf(0.0f);
        }
        Float res = null;
        try {
            Float f1 = Float.valueOf(Float.parseFloat(args[0]));
            Float f2 = Float.valueOf(Float.parseFloat(args[1]));
            Float min = Float.valueOf(0.0f);
            if (f1.floatValue() == 0.0f && f2.floatValue() != 0.0f) {
                min = f2;
            } else if (f1.floatValue() != 0.0f && f2.floatValue() == 0.0f) {
                min = f1;
            } else if (f1.floatValue() != 0.0f && f2.floatValue() != 0.0f) {
                min = Float.valueOf(Math.min(f1.floatValue(), f2.floatValue()));
            } else {
                res = Float.valueOf(0.0f);
                return res;
            }
            res = Float.valueOf(Math.abs(f1.floatValue() - f2.floatValue()) / min.floatValue());
        }
        catch (NumberFormatException nfe) {
            res = Float.valueOf(Float.NaN);
        }
        return res;
    }

    @Override
    public Function.ArgType getArgType() {
        return Function.ArgType.NUMERIC;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(",");
        sb.append(this.getDescription());
        sb.append(",");
        sb.append(this.getClass().getName());
        sb.append(",");
        sb.append(Float.class.getName());
        sb.append(",");
        sb.append(2);
        sb.append(",");
        sb.append(Float.class.getName());
        sb.append(",");
        sb.append(Float.class.getName());
        return sb.toString();
    }
}

