/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.rules.functions;

import com.walmart.productgenome.matching.models.rules.functions.Function;

public class NormAbsSim
extends Function {
    public static final String NAME = "NORM_ABS_SIM";
    public static final String DESCRIPTION = "1 - Normalised Absolute Difference";
    public static final int NUM_ARGS = 2;

    public NormAbsSim() {
        super(NAME, DESCRIPTION);
    }

    public NormAbsSim(String name, String description) {
        super(name, description);
    }

    @Override
    public Float compute(String[] args) throws IllegalArgumentException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected number of arguments: 2");
        }
        if (args[0] == null || args[1] == null) {
            return Float.valueOf(0.0f);
        }
        Float res = null;
        try {
            Float f1 = Float.valueOf(Float.parseFloat(args[0]));
            Float f2 = Float.valueOf(Float.parseFloat(args[1]));
            Float max = Float.valueOf(0.0f);
            if (f1.floatValue() == 0.0f && f2.floatValue() != 0.0f) {
                max = f2;
            } else if (f1.floatValue() != 0.0f && f2.floatValue() == 0.0f) {
                max = f1;
            } else if (f1.floatValue() != 0.0f && f2.floatValue() != 0.0f) {
                max = Float.valueOf(Math.max(f1.floatValue(), f2.floatValue()));
            } else {
                res = Float.valueOf(0.0f);
                return res;
            }
            res = Float.valueOf(Math.abs(f1.floatValue() - f2.floatValue()) / max.floatValue());
        }
        catch (NumberFormatException nfe) {
            res = Float.valueOf(Float.NaN);
        }
        return Float.valueOf(1.0f - res.floatValue());
    }

    @Override
    public Function.ArgType getArgType() {
        return Function.ArgType.STRING;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(",");
        sb.append(this.getDescription());
        sb.append(",");
        sb.append(this.getClass().getName());
        sb.append(",");
        sb.append(Float.class.getName());
        sb.append(",");
        sb.append(2);
        sb.append(",");
        sb.append(Float.class.getName());
        sb.append(",");
        sb.append(Float.class.getName());
        return sb.toString();
    }
}

