/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.savers;

import com.walmart.productgenome.matching.evaluate.EvaluationSummary;
import com.walmart.productgenome.matching.utils.JSONUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class EvaluationSummarySaver {
    private static String getEvaluationSummaryFilePath(String projectName, String evaluationSummaryName) {
        return "./ems/" + projectName + "/" + evaluationSummaryName + ".evalsum";
    }

    public static void saveEvaluationSummary(EvaluationSummary evaluationSummary) throws IOException {
        String projectName = evaluationSummary.getProjectName();
        String evaluationSummaryName = evaluationSummary.getName();
        String evaluationSummaryFilePath = EvaluationSummarySaver.getEvaluationSummaryFilePath(projectName, evaluationSummaryName);
        String evaluationSummaryJSON = JSONUtils.getEvaluationSummaryJSON(evaluationSummary);
        BufferedWriter bw = new BufferedWriter(new FileWriter(evaluationSummaryFilePath));
        bw.write(evaluationSummaryJSON);
        bw.close();
    }
}

