/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.savers;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.rules.Feature;
import com.walmart.productgenome.matching.models.rules.functions.Function;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public class FeatureSaver {
    private static String getAllFeaturesFilePath(String projectName) {
        return "./ems/" + projectName + "/" + "all.features";
    }

    public static void addFeature(String projectName, Feature feature) throws IOException {
        String allFeaturesFilePath = FeatureSaver.getAllFeaturesFilePath(projectName);
        FeatureSaver.addFeature(feature, allFeaturesFilePath);
    }

    private static void printFeature(CSVPrinter featurePrinter, Feature feature) throws IOException {
        featurePrinter.print((Object)feature.getName());
        featurePrinter.print((Object)feature.getTable1Name());
        featurePrinter.print((Object)feature.getTable2Name());
        featurePrinter.print((Object)feature.getFunction().getName());
        featurePrinter.print((Object)feature.getAttribute1().getName());
        featurePrinter.print((Object)feature.getAttribute1().getType().name());
        featurePrinter.print((Object)feature.getAttribute2().getName());
        featurePrinter.print((Object)feature.getAttribute2().getType().name());
        featurePrinter.println();
    }

    public static void addFeature(Feature feature, String allFeaturesFilePath) throws IOException {
        File file = new File(allFeaturesFilePath);
        boolean exists = false;
        if (file.exists()) {
            exists = true;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(allFeaturesFilePath, true));
        CSVPrinter featurePrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
        if (!exists) {
            FeatureSaver.printHeader(featurePrinter);
        }
        FeatureSaver.printFeature(featurePrinter, feature);
        featurePrinter.close();
        bw.close();
    }

    public static void saveFeature(String projectName, Feature feature, Project project) throws IOException {
        String allFeaturesFilePath = FeatureSaver.getAllFeaturesFilePath(projectName);
        FeatureSaver.saveFeature(feature, allFeaturesFilePath, project);
    }

    public static void saveFeature(Feature feature, String allFeaturesFilePath, Project project) throws IOException {
        FileReader r = new FileReader(allFeaturesFilePath);
        CSVParser parser = new CSVParser((Reader)r);
        List records = parser.getRecords();
        r.close();
        ArrayList<Feature> features = new ArrayList<Feature>();
        int size = records.size();
        boolean found = false;
        int i = 1;
        while (i < size) {
            CSVRecord rec = (CSVRecord)records.get(i);
            String featureName = rec.get(0).trim();
            if (featureName.equals(feature.getName())) {
                features.add(feature);
                found = true;
            } else {
                String table1Name = rec.get(1).trim();
                String table2Name = rec.get(2).trim();
                String functionName = rec.get(3).trim();
                String attr1Name = rec.get(4).trim();
                String attr1Type = rec.get(5).trim();
                String attr2Name = rec.get(6).trim();
                String attr2Type = rec.get(7).trim();
                String projectName = project.getName();
                Function function = project.findFunctionByName(functionName);
                Attribute attribute1 = new Attribute(attr1Name, Attribute.Type.valueOf(attr1Type));
                Attribute attribute2 = new Attribute(attr2Name, Attribute.Type.valueOf(attr2Type));
                Feature f = new Feature(featureName, function, projectName, table1Name, table2Name, attribute1, attribute2);
                features.add(f);
            }
            ++i;
        }
        if (!found) {
            features.add(feature);
        }
        FeatureSaver.saveAllFeatures(features, allFeaturesFilePath);
    }

    public static void saveAllFeatures(Project project) throws IOException {
        String projectName = project.getName();
        String allFeaturesFilePath = FeatureSaver.getAllFeaturesFilePath(projectName);
        FeatureSaver.saveAllFeatures(project.getFeatures(), allFeaturesFilePath);
    }

    private static void printHeader(CSVPrinter featurePrinter) throws IOException {
        featurePrinter.print((Object)"feature_name");
        featurePrinter.print((Object)"table1_name");
        featurePrinter.print((Object)"table2_name");
        featurePrinter.print((Object)"function_name");
        featurePrinter.print((Object)"attribute1_name");
        featurePrinter.print((Object)"attribute1_type");
        featurePrinter.print((Object)"attribute2_name");
        featurePrinter.print((Object)"attribute2_type");
        featurePrinter.println();
    }

    private static void saveAllFeatures(List<Feature> features, String allFeaturesFilePath) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(allFeaturesFilePath));
        CSVPrinter featurePrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
        FeatureSaver.printHeader(featurePrinter);
        for (Feature feature : features) {
            FeatureSaver.printFeature(featurePrinter, feature);
        }
        featurePrinter.close();
        bw.close();
    }
}

