/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.savers;

import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.rules.functions.Function;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public class FunctionSaver {
    private static String getAllFunctionsFilePath(String projectName) {
        return "./ems/" + projectName + "/" + "all.functions";
    }

    public static void addFunction(String projectName, Function function) throws IOException {
        String allFunctionsFilePath = FunctionSaver.getAllFunctionsFilePath(projectName);
        FunctionSaver.addFunction(function, allFunctionsFilePath);
    }

    public static void addFunctions(String projectName, List<Function> functions) throws IOException {
        String allFunctionsFilePath = FunctionSaver.getAllFunctionsFilePath(projectName);
        FunctionSaver.addFunctions(functions, allFunctionsFilePath);
    }

    public static void addFunction(Function function, String allFunctionsFilePath) throws IOException {
        File file = new File(allFunctionsFilePath);
        boolean exists = false;
        if (file.exists()) {
            exists = true;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(allFunctionsFilePath, true));
        CSVPrinter functionPrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
        if (!exists) {
            FunctionSaver.printHeader(functionPrinter);
        }
        FunctionSaver.printFunction(functionPrinter, function);
        functionPrinter.close();
        bw.close();
    }

    public static void addFunctions(List<Function> functions, String allFunctionsFilePath) throws IOException {
        File file = new File(allFunctionsFilePath);
        boolean exists = false;
        if (file.exists()) {
            exists = true;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(allFunctionsFilePath, true));
        CSVPrinter functionPrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
        if (!exists) {
            FunctionSaver.printHeader(functionPrinter);
        }
        for (Function function : functions) {
            FunctionSaver.printFunction(functionPrinter, function);
        }
        functionPrinter.close();
        bw.close();
    }

    public static void saveFunction(String projectName, Function function) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String allFunctionsFilePath = FunctionSaver.getAllFunctionsFilePath(projectName);
        FunctionSaver.saveFunction(function, allFunctionsFilePath);
    }

    public static void saveFunction(Function function, String allFunctionsFilePath) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        FileReader r = new FileReader(allFunctionsFilePath);
        CSVParser parser = new CSVParser((Reader)r);
        List records = parser.getRecords();
        r.close();
        ArrayList<Function> functions = new ArrayList<Function>();
        int size = records.size();
        boolean found = false;
        int i = 1;
        while (i < size) {
            CSVRecord rec = (CSVRecord)records.get(i);
            String functionName = rec.get(0).trim();
            if (functionName.equals(function.getName())) {
                functions.add(function);
                found = true;
            } else {
                String functionDescription = rec.get(1).trim();
                String className = rec.get(2).trim();
                Class<?> functionClass = Class.forName(className);
                Constructor<?> constructor = functionClass.getConstructor(String.class, String.class);
                Function f = (Function)constructor.newInstance(functionName, functionDescription);
                functions.add(f);
            }
            ++i;
        }
        if (!found) {
            functions.add(function);
        }
        FunctionSaver.saveAllFunctions(functions, allFunctionsFilePath);
    }

    public static void saveAllFunctions(Project project) throws IOException {
        String projectName = project.getName();
        String allFunctionsFilePath = FunctionSaver.getAllFunctionsFilePath(projectName);
        FunctionSaver.saveAllFunctions(project.getFunctions(), allFunctionsFilePath);
    }

    private static void saveAllFunctions(List<Function> functions, String allFunctionsFilePath) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(allFunctionsFilePath));
        CSVPrinter functionPrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
        FunctionSaver.printHeader(functionPrinter);
        for (Function function : functions) {
            FunctionSaver.printFunction(functionPrinter, function);
        }
        functionPrinter.close();
        bw.close();
    }

    private static void printHeader(CSVPrinter functionPrinter) throws IOException {
        functionPrinter.print((Object)"function_name");
        functionPrinter.print((Object)"function_description");
        functionPrinter.print((Object)"function_class_name");
        functionPrinter.println();
    }

    private static void printFunction(CSVPrinter functionPrinter, Function function) throws IOException {
        functionPrinter.print((Object)function.getName());
        functionPrinter.print((Object)function.getDescription());
        functionPrinter.print((Object)function.getClass().getName());
        functionPrinter.println();
    }
}

