/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.savers;

import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.rules.Matcher;
import com.walmart.productgenome.matching.models.rules.Rule;
import com.walmart.productgenome.matching.utils.ParsingUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public class MatcherSaver {
    private static String getAllMatchersFilePath(String projectName) {
        return "./ems/" + projectName + "/" + "all.matchers";
    }

    public static void addMatcher(String projectName, Matcher matcher) throws IOException {
        String allMatchersFilePath = MatcherSaver.getAllMatchersFilePath(projectName);
        MatcherSaver.addMatcher(matcher, allMatchersFilePath);
    }

    private static void printMatcher(CSVPrinter matcherPrinter, Matcher matcher) throws IOException {
        matcherPrinter.print((Object)matcher.getName());
        matcherPrinter.print((Object)matcher.getTable1Name());
        matcherPrinter.print((Object)matcher.getTable2Name());
        matcherPrinter.print((Object)matcher.getShortDisplayString());
        matcherPrinter.println();
    }

    public static void addMatcher(Matcher matcher, String allMatchersFilePath) throws IOException {
        File file = new File(allMatchersFilePath);
        boolean exists = false;
        if (file.exists()) {
            exists = true;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(allMatchersFilePath, true));
        CSVPrinter matcherPrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
        if (!exists) {
            MatcherSaver.printHeader(matcherPrinter);
        }
        MatcherSaver.printMatcher(matcherPrinter, matcher);
        matcherPrinter.close();
        bw.close();
    }

    public static void saveMatcher(String projectName, Matcher matcher, Project project) throws IOException {
        String allMatchersFilePath = MatcherSaver.getAllMatchersFilePath(projectName);
        MatcherSaver.saveMatcher(matcher, allMatchersFilePath, project);
    }

    public static void saveMatcher(Matcher matcher, String allMatchersFilePath, Project project) throws IOException {
        FileReader reader = new FileReader(allMatchersFilePath);
        CSVParser parser = new CSVParser((Reader)reader);
        List records = parser.getRecords();
        reader.close();
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        int size = records.size();
        boolean found = false;
        int i = 1;
        while (i < size) {
            CSVRecord rec = (CSVRecord)records.get(i);
            String matcherName = rec.get(0).trim();
            if (matcherName.equals(matcher.getName())) {
                matchers.add(matcher);
                found = true;
            } else {
                String table1Name = rec.get(1).trim();
                String table2Name = rec.get(2).trim();
                String matcherString = rec.get(3).trim();
                List<Rule> rules = ParsingUtils.parseMatcherFromShortDisplayString(project, matcherString);
                String projectName = project.getName();
                Matcher m = new Matcher(matcherName, projectName, table1Name, table2Name, rules);
                matchers.add(m);
            }
            ++i;
        }
        if (!found) {
            matchers.add(matcher);
        }
        MatcherSaver.saveAllMatchers(matchers, allMatchersFilePath);
    }

    public static void saveAllMatchers(Project project) throws IOException {
        String projectName = project.getName();
        String allMatchersFilePath = MatcherSaver.getAllMatchersFilePath(projectName);
        MatcherSaver.saveAllMatchers(project.getMatchers(), allMatchersFilePath);
    }

    private static void printHeader(CSVPrinter matcherPrinter) throws IOException {
        matcherPrinter.print((Object)"matcher_name");
        matcherPrinter.print((Object)"table1_name");
        matcherPrinter.print((Object)"table2_name");
        matcherPrinter.print((Object)"matcher_string");
        matcherPrinter.println();
    }

    private static void saveAllMatchers(List<Matcher> matchers, String allMatchersFilePath) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(allMatchersFilePath));
        CSVPrinter matcherPrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
        MatcherSaver.printHeader(matcherPrinter);
        for (Matcher matcher : matchers) {
            MatcherSaver.printMatcher(matcherPrinter, matcher);
        }
        matcherPrinter.close();
        bw.close();
    }
}

