/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.savers;

import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.rules.Rule;
import com.walmart.productgenome.matching.models.rules.Term;
import com.walmart.productgenome.matching.utils.ParsingUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public class RuleSaver {
    private static String getAllRulesFilePath(String projectName) {
        return "./ems/" + projectName + "/" + "all.rules";
    }

    public static void addRule(String projectName, Rule rule) throws IOException {
        String allRulesFilePath = RuleSaver.getAllRulesFilePath(projectName);
        RuleSaver.addRule(rule, allRulesFilePath);
    }

    private static void printRule(CSVPrinter rulePrinter, Rule rule) throws IOException {
        rulePrinter.print((Object)rule.getName());
        rulePrinter.print((Object)rule.getTable1Name());
        rulePrinter.print((Object)rule.getTable2Name());
        rulePrinter.print((Object)rule.getDisplayString());
        rulePrinter.println();
    }

    public static void addRule(Rule rule, String allRulesFilePath) throws IOException {
        File file = new File(allRulesFilePath);
        boolean exists = false;
        if (file.exists()) {
            exists = true;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(allRulesFilePath, true));
        CSVPrinter rulePrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
        if (!exists) {
            RuleSaver.printHeader(rulePrinter);
        }
        RuleSaver.printRule(rulePrinter, rule);
        rulePrinter.close();
        bw.close();
    }

    public static void saveRule(String projectName, Rule rule, Project project) throws IOException {
        String allRulesFilePath = RuleSaver.getAllRulesFilePath(projectName);
        RuleSaver.saveRule(rule, allRulesFilePath, project);
    }

    public static void saveRule(Rule rule, String allRulesFilePath, Project project) throws IOException {
        FileReader reader = new FileReader(allRulesFilePath);
        CSVParser parser = new CSVParser((Reader)reader);
        List records = parser.getRecords();
        reader.close();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        int size = records.size();
        boolean found = false;
        int i = 1;
        while (i < size) {
            CSVRecord rec = (CSVRecord)records.get(i);
            String ruleName = rec.get(0).trim();
            if (ruleName.equals(rule.getName())) {
                rules.add(rule);
                found = true;
            } else {
                String table1Name = rec.get(1).trim();
                String table2Name = rec.get(2).trim();
                String ruleString = rec.get(3).trim();
                List<Term> terms = ParsingUtils.parseRuleFromDisplayString(project, ruleString);
                String projectName = project.getName();
                Rule r = new Rule(ruleName, projectName, table1Name, table2Name, terms);
                rules.add(r);
            }
            ++i;
        }
        if (!found) {
            rules.add(rule);
        }
        RuleSaver.saveAllRules(rules, allRulesFilePath);
    }

    public static void saveAllRules(Project project) throws IOException {
        String projectName = project.getName();
        String allRulesFilePath = RuleSaver.getAllRulesFilePath(projectName);
        RuleSaver.saveAllRules(project.getRules(), allRulesFilePath);
    }

    private static void printHeader(CSVPrinter rulePrinter) throws IOException {
        rulePrinter.print((Object)"rule_name");
        rulePrinter.print((Object)"table1_name");
        rulePrinter.print((Object)"table2_name");
        rulePrinter.print((Object)"rule_string");
        rulePrinter.println();
    }

    private static void saveAllRules(List<Rule> rules, String allRulesFilePath) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(allRulesFilePath));
        CSVPrinter rulePrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
        RuleSaver.printHeader(rulePrinter);
        for (Rule rule : rules) {
            RuleSaver.printRule(rulePrinter, rule);
        }
        rulePrinter.close();
        bw.close();
    }
}

