/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.models.savers;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.utils.JSONUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class TableSaver {
    public static void saveTable(Table table) {
        String tableName = table.getName();
        String projectName = table.getProjectName();
        String tableFilePath = "./ems/" + projectName + "/" + tableName + ".table";
        TableSaver.saveTable(table, tableFilePath);
    }

    public static void saveTable(Table table, String tableFilePath) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(tableFilePath));
            bw.write("@info");
            String tableJSON = JSONUtils.getTableJSON(table);
            bw.write(tableJSON);
            bw.newLine();
            bw.newLine();
            bw.write("@data");
            bw.newLine();
            CSVPrinter dataPrinter = new CSVPrinter((Appendable)bw, CSVFormat.DEFAULT.toBuilder().withRecordSeparator("\n").build());
            List<Attribute> attributes = table.getAttributes();
            for (Attribute a : attributes) {
                dataPrinter.print((Object)(String.valueOf(a.getName()) + ":" + a.getType().name()));
            }
            dataPrinter.println();
            for (Tuple t : table.getAllTuplesInOrder()) {
                for (Attribute a : attributes) {
                    dataPrinter.print(t.getAttributeValue(a));
                }
                dataPrinter.println();
            }
            dataPrinter.close();
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

