/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.data.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;

public class BlockingService {
    private static Attribute getPairIdAttribute() {
        return new Attribute("pairId", Attribute.Type.INTEGER);
    }

    private static void addAdditionalAttributes(List<Attribute> attributes, List<Attribute> additionalAttributes, String tableName) {
        if (additionalAttributes != null) {
            for (Attribute attribute : additionalAttributes) {
                attributes.add(new Attribute(String.valueOf(tableName) + "." + attribute.getName(), attribute.getType()));
            }
        }
    }

    private static Map<Object, List<Object>> createIndex(Table table, Attribute blockingAttribute, Attribute idAttribute) {
        HashMap<Object, List<Object>> index = new HashMap<Object, List<Object>>();
        for (Tuple tuple : table.getAllTuples()) {
            Object value = tuple.getAttributeValue(blockingAttribute);
            Object tupleId = tuple.getAttributeValue(idAttribute);
            List postingsList = !index.containsKey(value) ? new ArrayList() : (List)index.get(value);
            postingsList.add(tupleId);
            index.put(value, postingsList);
        }
        return index;
    }

    public static Table block(Table table1, Table table2, Attribute table1BlockingAttribute, Attribute table2BlockingAttribute, List<Attribute> table1AdditionalAttributes, List<Attribute> table2AdditionalAttributes, String candsetName, String projectName) {
        if (table1BlockingAttribute.getType() != table2BlockingAttribute.getType()) {
            throw new InputMismatchException("[EMS] blocking attributes must be of the same type");
        }
        Attribute idAttribute1 = table1.getIdAttribute();
        Map<Object, List<Object>> index = BlockingService.createIndex(table1, table1BlockingAttribute, idAttribute1);
        String id1Name = String.valueOf(table1.getName()) + "." + idAttribute1.getName();
        Attribute id1 = new Attribute(id1Name, idAttribute1.getType());
        Attribute idAttribute2 = table2.getIdAttribute();
        String id2Name = String.valueOf(table2.getName()) + "." + idAttribute2.getName();
        Attribute id2 = new Attribute(id2Name, idAttribute2.getType());
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute pairIdAttribute = BlockingService.getPairIdAttribute();
        attributes.add(pairIdAttribute);
        attributes.add(id1);
        attributes.add(id2);
        BlockingService.addAdditionalAttributes(attributes, table1AdditionalAttributes, table1.getName());
        BlockingService.addAdditionalAttributes(attributes, table2AdditionalAttributes, table2.getName());
        Table candset = new Table(candsetName, pairIdAttribute, attributes, projectName);
        HashMap<Attribute, Object> data = new HashMap<Attribute, Object>();
        int pairId = 1;
        for (Tuple table2Tuple : table2.getAllTuplesInOrder()) {
            Object value = table2Tuple.getAttributeValue(table2BlockingAttribute);
            Object tupleId = table2Tuple.getAttributeValue(idAttribute2);
            if (!index.containsKey(value)) continue;
            List<Object> id1Values = index.get(value);
            for (Object id1Val : id1Values) {
                Object attributeValue;
                data.put(pairIdAttribute, pairId);
                data.put(id1, id1Val);
                data.put(id2, tupleId);
                int i = 3;
                Tuple table1Tuple = table1.getTuple(id1Val);
                if (table1AdditionalAttributes != null) {
                    for (Attribute attribute : table1AdditionalAttributes) {
                        attributeValue = table1Tuple.getAttributeValue(attribute);
                        data.put((Attribute)attributes.get(i), attributeValue);
                        ++i;
                    }
                }
                if (table2AdditionalAttributes != null) {
                    for (Attribute attribute : table2AdditionalAttributes) {
                        attributeValue = table2Tuple.getAttributeValue(attribute);
                        data.put((Attribute)attributes.get(i), attributeValue);
                        ++i;
                    }
                }
                Tuple pair = new Tuple(data);
                candset.addTuple(pair);
                ++pairId;
                data.clear();
            }
        }
        return candset;
    }
}

