/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service;

import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.utils.JSONUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectService {
    private static Map<String, Project> projectMap = new HashMap<String, Project>();

    static {
        List<Project> projects = ProjectService.loadAllProjects();
        for (Project p : projects) {
            projectMap.put(p.getName(), p);
        }
    }

    static List<Project> loadAllProjects() {
        File[] files;
        ArrayList<Project> projects = new ArrayList<Project>();
        File dir = new File("./ems/");
        File[] fileArray = files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                if (f.isDirectory()) {
                    String projectName = f.getName();
                    Project p = JSONUtils.getProjectFromJSONFile(projectName);
                    projects.add(p);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return projects;
    }

    public static void saveTable(Project project, String tableName) {
        project.removeUnsavedTable(tableName);
        projectMap.put(project.getName(), project);
    }

    public static Project openProject(String projectName) {
        return projectMap.get(projectName);
    }

    public static void updateProject(Project project) {
        projectMap.put(project.getName(), project);
    }
}

