/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service;

import com.walmart.productgenome.matching.models.DefaultType;
import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.loaders.TableLoader;
import com.walmart.productgenome.matching.models.savers.TableSaver;
import com.walmart.productgenome.matching.service.ProjectService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableService {
    private static Map<String, List<String>> projectTableMap = new HashMap<String, List<String>>();
    private static Map<String, Map<String, Table>> tableCache = new HashMap<String, Map<String, Table>>();

    static {
        List<Project> projects = ProjectService.loadAllProjects();
        for (Project p : projects) {
            projectTableMap.put(p.getName(), p.getTableNames());
            tableCache.put(p.getName(), new HashMap());
        }
    }

    public static Table openTable(String projectName, String tableName) throws IOException {
        List<String> tableNames = projectTableMap.get(projectName);
        if (!tableNames.contains(tableName)) {
            return null;
        }
        Map<String, Table> tableMap = tableCache.get(projectName);
        Table table = tableMap.get(tableName);
        if (table == null) {
            System.out.println("Loading Project " + projectName + " -> Table " + tableName + " from disk");
            String tableFilePath = "./ems/" + projectName + "/" + tableName + ".table";
            table = TableLoader.loadTable(tableFilePath);
            tableMap.put(tableName, table);
            tableCache.put(projectName, tableMap);
        }
        return table;
    }

    public static void saveTableToDisk(Table table) {
        TableSaver.saveTable(table);
    }

    public static void addTableToProject(Project project, Table table, Set<DefaultType> defaultTypes) {
        String tableName = table.getName();
        project.addTableName(tableName);
        for (DefaultType defaultType : defaultTypes) {
            switch (defaultType) {
                case TABLE1: {
                    project.setDefaultTable1(tableName);
                    break;
                }
                case TABLE2: {
                    project.setDefaultTable2(tableName);
                    break;
                }
                case CAND_SET: {
                    project.setDefaultCandset(tableName);
                    break;
                }
                case MATCHES: {
                    project.setDefaultMatches(tableName);
                    break;
                }
                case GOLD: {
                    project.setDefaultGold(tableName);
                    break;
                }
            }
        }
        String projectName = project.getName();
        projectTableMap.put(projectName, project.getTableNames());
        Map<String, Table> tableMap = tableCache.get(projectName);
        if (tableMap == null) {
            tableMap = new HashMap<String, Table>();
        }
        tableMap.put(tableName, table);
        tableCache.put(projectName, tableMap);
        project.addUnsavedTable(tableName);
        ProjectService.updateProject(project);
    }
}

