/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.debug;

import com.walmart.productgenome.matching.models.audit.ItemPairAudit;
import com.walmart.productgenome.matching.models.audit.MatchStatus;
import com.walmart.productgenome.matching.models.data.Tuple;
import com.walmart.productgenome.matching.service.debug.MatchingSummary;
import java.util.HashMap;
import java.util.Map;

public class Debug {
    public static MatchingSummary getMatchingSummary(Map<Tuple, ItemPairAudit> itemPairAudits) {
        HashMap<String, Integer> totalMatchesByRule = new HashMap<String, Integer>();
        int totalPairs = itemPairAudits.size();
        int totalMatches = 0;
        for (ItemPairAudit itemPairAudit : itemPairAudits.values()) {
            if (itemPairAudit.getStatus() == MatchStatus.MATCH) {
                ++totalMatches;
            }
            for (String ruleName : itemPairAudit.getMatchingRuleNames()) {
                if (totalMatchesByRule.containsKey(ruleName)) {
                    totalMatchesByRule.put(ruleName, (Integer)totalMatchesByRule.get(ruleName) + 1);
                    continue;
                }
                totalMatchesByRule.put(ruleName, 1);
            }
        }
        return new MatchingSummary(totalPairs, totalMatches, totalMatchesByRule);
    }
}

