/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.explorer;

import com.google.common.base.Objects;
import com.walmart.productgenome.matching.models.data.Attribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics.ICombinatoricsVector;

public class AttrComb
implements Iterable<Attribute> {
    List<Attribute> attrs = new ArrayList<Attribute>();

    public AttrComb(ICombinatoricsVector<Attribute> attrs) {
        for (Attribute attr : attrs) {
            this.attrs.add(attr);
        }
    }

    public AttrComb(Attribute attr) {
        this.attrs.add(attr);
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.attrs.iterator();
    }

    public boolean contains(Attribute attr) {
        return this.attrs.contains(attr);
    }

    public Attribute get(int index) {
        return this.attrs.get(index);
    }

    public List<Attribute> getAttrs() {
        return this.attrs;
    }

    public String getAttrCombName() {
        String text = "";
        String delimiter = "";
        for (Attribute attr : this.attrs) {
            text = String.valueOf(text) + delimiter + attr.getName();
            delimiter = ", ";
        }
        return text;
    }

    public String getAttrCombType() {
        String text = "";
        String delimiter = "";
        for (Attribute attr : this.attrs) {
            text = String.valueOf(text) + delimiter + (Object)((Object)attr.getType());
            delimiter = ", ";
        }
        return text;
    }

    public int size() {
        return this.attrs.size();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("attrs", this.attrs).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attrs});
    }

    public boolean equals(Object object) {
        if (!(object instanceof AttrComb)) {
            return false;
        }
        AttrComb that = (AttrComb)object;
        for (Attribute attr : this.attrs) {
            if (that.attrs.contains(attr)) continue;
            return false;
        }
        return true;
    }
}

