/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.explorer;

import com.google.common.base.Objects;
import com.walmart.productgenome.matching.models.data.Attribute;
import java.util.Map;

public class AttrStats {
    private final Attribute.Type type;
    private final int totalValues;
    private final int totalMissing;
    private final int totalUnique;
    private final int totalDistinct;
    private final Map<Object, Integer> topKFrequencies;
    private final double avgLength;
    private final double avgNumTokens;

    public AttrStats(Attribute.Type type, int totalValues, int totalMissing, int totalUnique, int totalDistinct, Map<Object, Integer> topKFrequencies, double avgLength, double avgNumTokens) {
        this.type = type;
        this.totalValues = totalValues;
        this.totalMissing = totalMissing;
        this.totalUnique = totalUnique;
        this.totalDistinct = totalDistinct;
        this.topKFrequencies = topKFrequencies;
        this.avgLength = avgLength;
        this.avgNumTokens = avgNumTokens;
    }

    public int getTotalValues() {
        return this.totalValues;
    }

    public int getTotalMissing() {
        return this.totalMissing;
    }

    public int getTotalUnique() {
        return this.totalUnique;
    }

    public int getTotalDistinct() {
        return this.totalDistinct;
    }

    public Map<Object, Integer> getTopKFrequencies() {
        return this.topKFrequencies;
    }

    public double getPercentUnique() {
        return (float)(100 * this.getTotalUnique()) / (float)(this.getTotalValues() - this.getTotalMissing());
    }

    public double getPercentMissing() {
        return (float)(100 * this.getTotalMissing()) / (float)this.getTotalValues();
    }

    public double getAvgLength() {
        return this.avgLength;
    }

    public double getAvgNumTokens() {
        return this.avgNumTokens;
    }

    public Attribute.Type getType() {
        return this.type;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("totalValues", this.totalValues).add("totalMissing", this.totalMissing).add("totalUnique", this.totalUnique).add("totalDistinct", this.totalDistinct).add("topKFrequencies", this.topKFrequencies).toString();
    }
}

