/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.explorer;

import com.walmart.productgenome.matching.models.Constants;
import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.service.explorer.AttrComb;
import com.walmart.productgenome.matching.service.explorer.AttrStats;
import com.walmart.productgenome.matching.service.explorer.Explorer;
import com.walmart.productgenome.matching.service.explorer.TableStats;
import java.util.ArrayList;
import java.util.List;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;

public class AttributeSelector {
    private final Table table;
    private final TableStats tableStats;
    private final int maxCombination;
    private final int topKFreq;
    private final int maxNumValues;
    private final List<Attribute> filteredAttrs;
    private int minUniqueForBest = 90;
    private int maxMissing = 50;
    private int minDistinct = 3;

    public AttributeSelector(Table table2, TableStats tableStats, int topKFreq, int maxNumValues, int maxCombination) {
        this.table = table2;
        this.tableStats = tableStats;
        this.maxCombination = maxCombination;
        this.topKFreq = topKFreq;
        this.maxNumValues = maxNumValues;
        this.filteredAttrs = this.getFilteredAttrs();
    }

    public void getBestAttrCombs() {
        int i = 1;
        while (i < this.maxCombination + 1) {
            List<AttrComb> allAttrCombs = this.genAttrCombs(i);
            List<AttrComb> filteredAttrCombs = this.filterAlreadySeenCombs(allAttrCombs);
            this.getBestAttrCombs(i, filteredAttrCombs);
            ++i;
        }
    }

    private void getBestAttrCombs(int attrCount, List<AttrComb> attrCombs) {
        for (AttrComb attrComb : attrCombs) {
            AttrStats attrStats = null;
            attrStats = this.tableStats.hasAttrStats(attrComb) ? this.tableStats.getAttrStats(attrComb) : this.getAttrStatForComb(attrComb);
            if (!this.isCombEnoughForMatching(attrStats)) continue;
            this.tableStats.putAttrStatsForComb(attrComb, attrStats);
            this.tableStats.putLayeredSelectedAttrs(attrCount, attrComb);
        }
    }

    private List<Attribute> getFilteredAttrs() {
        ArrayList<Attribute> filteredAttrs = new ArrayList<Attribute>();
        for (Attribute attr : this.table.getAttributes()) {
            AttrStats attrStats;
            if (attr.equals(this.table.getIdAttribute()) || this.shouldFilterAttribute(attrStats = this.tableStats.getAttrStats(new AttrComb(attr)))) continue;
            filteredAttrs.add(attr);
        }
        return filteredAttrs;
    }

    private List<AttrComb> genAttrCombs(int setSize) {
        ArrayList<AttrComb> attrCombs = new ArrayList<AttrComb>();
        ICombinatoricsVector initialVector = Factory.createVector(this.filteredAttrs);
        Generator gen = Factory.createSimpleCombinationGenerator((ICombinatoricsVector)initialVector, (int)setSize);
        for (ICombinatoricsVector combination : gen) {
            attrCombs.add(new AttrComb((ICombinatoricsVector<Attribute>)combination));
        }
        return attrCombs;
    }

    private List<AttrComb> filterAlreadySeenCombs(List<AttrComb> combs) {
        ArrayList<AttrComb> filteredCombs = new ArrayList<AttrComb>();
        for (AttrComb comb : combs) {
            if (this.tableStats.isInBestCombs(comb)) continue;
            filteredCombs.add(comb);
        }
        return filteredCombs;
    }

    private boolean isCombEnoughForMatching(AttrStats attrStats) {
        return attrStats.getPercentUnique() >= (double)this.minUniqueForBest;
    }

    private boolean shouldFilterAttribute(AttrStats attrStats) {
        if (attrStats.getPercentMissing() > (double)this.maxMissing) {
            return true;
        }
        return attrStats.getTotalDistinct() < this.minDistinct + 1;
    }

    public AttrStats getAttrStatForComb(AttrComb attrs) {
        ArrayList attrValueLists = new ArrayList();
        for (Attribute attr : attrs) {
            attrValueLists.add(this.table.getAllValuesForAttribute(attr));
        }
        List zippedValueLists = this.zip(attrValueLists);
        ArrayList<Object> values = new ArrayList<Object>();
        for (List<Object> list : zippedValueLists) {
            String concatValues = this.concatStringsWSep(list, ", ");
            if (concatValues.equals("")) {
                values.add(Constants.MISSING_VALUE);
                continue;
            }
            values.add(concatValues);
        }
        return Explorer.getAttrStats(values, this.topKFreq, this.maxNumValues);
    }

    private <T> List<List<T>> zip(List<List<T>> lists) {
        ArrayList<List<T>> zipped = new ArrayList<List<T>>();
        for (List<T> list : lists) {
            int i = 0;
            int listSize = list.size();
            while (i < listSize) {
                ArrayList<T> list2;
                if (i >= zipped.size()) {
                    list2 = new ArrayList<T>();
                    zipped.add(list2);
                } else {
                    list2 = (ArrayList<T>)zipped.get(i);
                }
                list2.add(list.get(i));
                ++i;
            }
        }
        return zipped;
    }

    private String concatStringsWSep(List<Object> objects, String separator) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Object s : objects) {
            if (s.equals(Constants.MISSING_VALUE)) {
                return "";
            }
            sb.append(sep).append(s);
            sep = separator;
        }
        return sb.toString();
    }
}

