/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.explorer;

import com.walmart.productgenome.matching.daos.TableDao;
import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.service.explorer.AttributeSelector;
import com.walmart.productgenome.matching.service.explorer.ExplorerDriver;
import com.walmart.productgenome.matching.service.explorer.TableStats;
import java.io.IOException;
import org.junit.Before;
import org.junit.Test;

public class AttributeSelectorTest {
    Table table;
    TableStats tableStats;

    @Before
    public void readTable() throws IOException {
        String csvFilePath = "./data/books/walmart.csv";
        this.table = TableDao.importFromCSVWithHeader("Products", "walmart", csvFilePath);
        this.tableStats = ExplorerDriver.getTableStats(this.table, 0, 0);
    }

    @Test
    public void getBestAttrCombs() {
        AttributeSelector attrSelector = new AttributeSelector(this.table, this.tableStats, 100, 100, 3);
        attrSelector.getBestAttrCombs();
        Attribute isbn = new Attribute("isbn", Attribute.Type.TEXT);
        Attribute author = new Attribute("author", Attribute.Type.TEXT);
        Attribute binding = new Attribute("binding", Attribute.Type.TEXT);
        System.out.println(this.tableStats.printLayeredCombs());
    }
}

