/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.explorer;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.service.explorer.AttrComb;
import com.walmart.productgenome.matching.service.explorer.AttrStats;
import com.walmart.productgenome.matching.service.explorer.AttributeSelector;
import com.walmart.productgenome.matching.service.explorer.FrequencyAnalyzer;
import com.walmart.productgenome.matching.service.explorer.TableStats;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Explorer {
    public static TableStats getTableStats(Table table, int topKFreqs, int maxNumValues) {
        Map<AttrComb, AttrStats> attrStatsMap = Explorer.getAttrStatsMap(table, topKFreqs, maxNumValues);
        TableStats tableStats = new TableStats(attrStatsMap);
        return tableStats;
    }

    public static TableStats getTableStatsWithSelectedAttrs(Table table, int topKFreqs, int maxNumValues, int maxAttrCount) {
        TableStats tableStats = Explorer.getTableStats(table, topKFreqs, maxNumValues);
        AttributeSelector attrSelector = new AttributeSelector(table, tableStats, topKFreqs, maxNumValues, maxAttrCount);
        attrSelector.getBestAttrCombs();
        return tableStats;
    }

    private static Map<AttrComb, AttrStats> getAttrStatsMap(Table table, int topKFreqs, int maxNumValues) {
        HashMap<AttrComb, AttrStats> attrStatsMap = new HashMap<AttrComb, AttrStats>();
        for (Attribute attr : table.getAttributes()) {
            attrStatsMap.put(new AttrComb(attr), Explorer.getAttrStats(table, attr, topKFreqs, maxNumValues));
        }
        return attrStatsMap;
    }

    public static AttrStats getAttrStats(Table table, Attribute attr, int topKFreqs, int maxNumValues) {
        return Explorer.getAttrStats(attr.getType(), table.getAllValuesForAttribute(attr), topKFreqs, maxNumValues);
    }

    public static AttrStats getAttrStats(Attribute.Type type, List<Object> values, int topKFreqs, int maxNumValues) {
        FrequencyAnalyzer frequencyAnalyzer = Explorer.getAttrValueFrequencyAnalysis(values);
        AttrStats attrStats = new AttrStats(type, frequencyAnalyzer.getTotalValues(), frequencyAnalyzer.getTotalMissing(), frequencyAnalyzer.getTotalUnique(), frequencyAnalyzer.getTotalDistinct(), frequencyAnalyzer.getTopKFrequencies(topKFreqs, maxNumValues), frequencyAnalyzer.getAvgLength(), frequencyAnalyzer.getAvgNumTokens());
        return attrStats;
    }

    private static FrequencyAnalyzer getAttrValueFrequencyAnalysis(List<Object> attrValues) {
        FrequencyAnalyzer frequencyAnalyzer = new FrequencyAnalyzer();
        for (Object value : attrValues) {
            frequencyAnalyzer.addValue(value);
        }
        return frequencyAnalyzer;
    }

    public static AttrStats getAttrStats(List<Object> values, int topKFreq, int maxNumValues) {
        return Explorer.getAttrStats(null, values, topKFreq, maxNumValues);
    }
}

