/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.explorer;

import com.google.common.base.Objects;
import com.walmart.productgenome.matching.models.Constants;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FrequencyAnalyzer {
    private static final String TOKEN_DELIMITER = " ";
    private Map<Object, Integer> valueToFreq = new HashMap<Object, Integer>();
    private Map<Integer, Set<Object>> freqToValues = new TreeMap(Collections.reverseOrder());
    private int totalValues;
    private double avgLength;
    private double avgNumTokens;

    public void addValue(Object value) {
        this.setTotalValues(this.totalValues + 1);
        Integer count = this.valueToFreq.get(value);
        if (count == null) {
            count = 0;
        }
        String strValue = String.valueOf(value);
        this.setAvgLength((this.avgLength * (double)(this.totalValues - 1) + (double)strValue.length()) / (double)this.totalValues);
        this.setAvgNumTokens((this.avgNumTokens * (double)(this.totalValues - 1) + (double)this.getTokens(strValue).length) / (double)this.totalValues);
        this.updateValueToFreq(value, count);
        this.updateFreqToValues(value, count);
    }

    public int getTotalValues() {
        return this.totalValues;
    }

    public int getTotalDistinct() {
        return this.valueToFreq.size();
    }

    public int getTotalUnique() {
        return this.getValuesWithFreq(1).size();
    }

    public int getTotalMissing() {
        if (this.valueToFreq.containsKey(Constants.MISSING_VALUE)) {
            return this.valueToFreq.get(Constants.MISSING_VALUE);
        }
        return 0;
    }

    public int getFrequencyForValue(Object value) {
        if (this.valueToFreq.containsKey(value)) {
            return this.valueToFreq.get(value);
        }
        return 0;
    }

    public Set<Object> getValuesWithFreq(int freq) {
        if (this.freqToValues.containsKey(freq)) {
            return this.freqToValues.get(freq);
        }
        return new HashSet<Object>();
    }

    public double getAvgLength() {
        return this.avgLength;
    }

    public double getAvgNumTokens() {
        return this.avgNumTokens;
    }

    public Map<Object, Integer> getTopKFrequencies(int k, int maxNumValues) {
        LinkedHashMap<Object, Integer> topKFrequencies = new LinkedHashMap<Object, Integer>();
        int countk = 0;
        int countm = 0;
        for (Map.Entry<Integer, Set<Object>> entry : this.freqToValues.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            if (countk >= k) break;
            for (Object value : entry.getValue()) {
                if (countm >= maxNumValues) break;
                topKFrequencies.put(value, entry.getKey());
                ++countm;
            }
            ++countk;
        }
        return topKFrequencies;
    }

    private void updateValueToFreq(Object value, int count) {
        this.valueToFreq.put(value, count + 1);
    }

    private void updateFreqToValues(Object value, int count) {
        if (count > 0) {
            this.freqToValues.get(count).remove(value);
        }
        if (!this.freqToValues.containsKey(count + 1)) {
            HashSet valueSet = new HashSet();
            this.freqToValues.put(count + 1, valueSet);
        }
        this.freqToValues.get(count + 1).add(value);
    }

    private void setTotalValues(int value) {
        this.totalValues = value;
    }

    private void setAvgLength(double value) {
        this.avgLength = value;
    }

    private void setAvgNumTokens(double value) {
        this.avgNumTokens = value;
    }

    private String[] getTokens(String value) {
        return value.split(TOKEN_DELIMITER);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("valueToFreq", this.valueToFreq).toString();
    }
}

