/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.explorer;

import com.walmart.productgenome.matching.service.explorer.FrequencyAnalyzer;
import java.text.DecimalFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FrequencyAnalyzerTest {
    FrequencyAnalyzer frequencyAnalyzer;

    @Before
    public void init() {
        this.frequencyAnalyzer = new FrequencyAnalyzer();
        this.frequencyAnalyzer.addValue("Fatemah");
        this.frequencyAnalyzer.addValue("Fatemah");
        this.frequencyAnalyzer.addValue("Hossein");
        this.frequencyAnalyzer.addValue("Hossein");
        this.frequencyAnalyzer.addValue("Hossein");
        this.frequencyAnalyzer.addValue("Majid");
        this.frequencyAnalyzer.addValue("");
    }

    @Test
    public void testGetTotalValues() {
        Assert.assertTrue((this.frequencyAnalyzer.getTotalValues() == 7 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTotalMissing() {
        Assert.assertTrue((this.frequencyAnalyzer.getTotalMissing() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTotalUnique() {
        Assert.assertTrue((this.frequencyAnalyzer.getTotalUnique() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTotalDistinct() {
        Assert.assertTrue((this.frequencyAnalyzer.getTotalDistinct() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testGetFrequencyForValue() {
        Assert.assertTrue((this.frequencyAnalyzer.getFrequencyForValue("Hossein") == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetValuesWithFreq() {
        Assert.assertTrue((boolean)this.frequencyAnalyzer.getValuesWithFreq(1).contains("Majid"));
        Assert.assertTrue((boolean)this.frequencyAnalyzer.getValuesWithFreq(2).contains("Fatemah"));
    }

    @Test
    public void testGetTopKFrequencies() {
        Assert.assertTrue((boolean)this.frequencyAnalyzer.getTopKFrequencies(2, 2).containsKey("Hossein"));
        Assert.assertTrue((boolean)this.frequencyAnalyzer.getTopKFrequencies(2, 2).containsKey("Fatemah"));
    }

    @Test
    public void testGetAvgNumTokens() {
        Assert.assertTrue((this.frequencyAnalyzer.getAvgNumTokens() == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAvgLength() {
        DecimalFormat df = new DecimalFormat("#.##");
        Assert.assertTrue((boolean)df.format(this.frequencyAnalyzer.getAvgLength()).equals("5.71"));
    }
}

