/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.explorer;

import com.google.common.base.Objects;
import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.service.explorer.AttrComb;
import com.walmart.productgenome.matching.service.explorer.AttrStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableStats {
    private final Map<AttrComb, AttrStats> attrStatsMap;
    private Map<Integer, List<AttrComb>> layeredSelectedAttrs;
    private Map<AttrComb, Integer> attrCombsIdMap;
    private int id;

    public TableStats(Map<AttrComb, AttrStats> attrStatsMap) {
        this.attrStatsMap = attrStatsMap;
        this.layeredSelectedAttrs = new HashMap<Integer, List<AttrComb>>();
        this.attrCombsIdMap = new HashMap<AttrComb, Integer>();
        this.id = 1;
        for (AttrComb attrComb : attrStatsMap.keySet()) {
            this.attrCombsIdMap.put(attrComb, this.id);
            ++this.id;
        }
    }

    public Set<AttrComb> getAllAttrCombs() {
        return this.attrStatsMap.keySet();
    }

    public boolean hasAttrStats(AttrComb attrComb) {
        return this.attrStatsMap.containsKey(attrComb);
    }

    public void putAttrStatsForComb(AttrComb attrComb, AttrStats attrStats) {
        this.attrStatsMap.put(attrComb, attrStats);
        if (!this.attrCombsIdMap.containsKey(attrComb)) {
            this.attrCombsIdMap.put(attrComb, this.id);
            ++this.id;
        }
    }

    public AttrStats getAttrStats(AttrComb attrComb) {
        return this.attrStatsMap.get(attrComb);
    }

    public List<AttrComb> getAttributeCombsForLayer(int attrCount) {
        if (this.layeredSelectedAttrs.containsKey(attrCount)) {
            return this.layeredSelectedAttrs.get(attrCount);
        }
        return null;
    }

    public void putLayeredSelectedAttrs(int attrCount, AttrComb attrComb) {
        if (this.layeredSelectedAttrs.containsKey(attrCount)) {
            this.layeredSelectedAttrs.get(attrCount).add(attrComb);
        } else {
            ArrayList<AttrComb> attrCombs = new ArrayList<AttrComb>();
            attrCombs.add(attrComb);
            this.layeredSelectedAttrs.put(attrCount, attrCombs);
        }
    }

    public Integer getAttrCombId(AttrComb attrComb) {
        return this.attrCombsIdMap.get(attrComb);
    }

    public AttrComb getAttrCombById(Integer id) {
        for (Map.Entry<AttrComb, Integer> entry : this.attrCombsIdMap.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isInBestCombs(AttrComb inComb) {
        for (Map.Entry<Integer, List<AttrComb>> entry : this.layeredSelectedAttrs.entrySet()) {
            for (AttrComb attrComb : entry.getValue()) {
                boolean isSubset = true;
                for (Attribute attr : attrComb) {
                    if (inComb.contains(attr)) continue;
                    isSubset = false;
                }
                if (!isSubset) continue;
                return true;
            }
        }
        return false;
    }

    public String printLayeredCombs() {
        String text = "";
        for (Map.Entry<Integer, List<AttrComb>> entry : this.layeredSelectedAttrs.entrySet()) {
            text = String.valueOf(text) + "===== " + entry.getKey() + " =====\n";
            for (AttrComb attrComb : entry.getValue()) {
                text = String.valueOf(text) + attrComb + "\n";
            }
        }
        return text;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("attrStatsMap", this.attrStatsMap).toString();
    }
}

