/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.recommender;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.rules.functions.EuclideanDistanceFunction;
import com.walmart.productgenome.matching.models.rules.functions.Function;
import com.walmart.productgenome.matching.models.rules.functions.Jaccard;
import com.walmart.productgenome.matching.models.rules.functions.JaroSimilarityFunction;
import com.walmart.productgenome.matching.models.rules.functions.JaroWinklerSimilarityFunction;
import com.walmart.productgenome.matching.models.rules.functions.LevenshteinSimilarity;
import com.walmart.productgenome.matching.models.rules.functions.MongeElkanSimilarity;
import com.walmart.productgenome.matching.models.rules.functions.NormAbsDiff;
import com.walmart.productgenome.matching.models.rules.functions.SoundexSimilarityFunction;
import com.walmart.productgenome.matching.service.explorer.AttrStats;
import java.util.ArrayList;
import java.util.List;

public class FunctionRecommender {
    public static List<Function> getRecommendedFunctionsForType(List<Function> allFunctions, Attribute.Type type) {
        switch (type) {
            case BOOLEAN: {
                return FunctionRecommender.getFunctionsForText(allFunctions);
            }
            case FLOAT: {
                return FunctionRecommender.getFunctionsForNumeric(allFunctions);
            }
            case INTEGER: {
                return FunctionRecommender.getFunctionsForNumeric(allFunctions);
            }
            case LONG: {
                return FunctionRecommender.getFunctionsForNumeric(allFunctions);
            }
            case TEXT: {
                return FunctionRecommender.getFunctionsForText(allFunctions);
            }
        }
        return FunctionRecommender.getFunctionsForText(allFunctions);
    }

    private static List<Function> getFunctionsForNumeric(List<Function> allFunctions) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Function function : allFunctions) {
            if (function.getArgType() != Function.ArgType.NUMERIC) continue;
            functions.add(function);
        }
        return functions;
    }

    private static List<Function> getFunctionsForText(List<Function> allFunctions) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Function function : allFunctions) {
            if (function.getArgType() != Function.ArgType.STRING) continue;
            functions.add(function);
        }
        return functions;
    }

    public static List<Function> getRecFunctionsForAttr(List<Function> allFunctions, AttrStats attrStats) {
        ArrayList<Function> functions = new ArrayList<Function>();
        if (attrStats.getType().equals((Object)Attribute.Type.FLOAT) || attrStats.getType().equals((Object)Attribute.Type.INTEGER) || attrStats.getType().equals((Object)Attribute.Type.LONG)) {
            functions.addAll(FunctionRecommender.getFunctionsForNumeric(allFunctions));
            return functions;
        }
        if (attrStats.getType().equals((Object)Attribute.Type.TEXT)) {
            double avgLength = attrStats.getAvgLength();
            double avgNumTokens = attrStats.getAvgNumTokens();
            functions.addAll(allFunctions);
            functions.remove(new NormAbsDiff());
            if (Double.compare(avgLength, 10.0) > 0) {
                functions.remove(new JaroSimilarityFunction());
                functions.remove(new SoundexSimilarityFunction());
            }
            if (Double.compare(avgLength, 20.0) > 0 && Double.compare(avgNumTokens, 2.0) > 0) {
                functions.remove(new JaroWinklerSimilarityFunction());
                functions.remove(new LevenshteinSimilarity());
                functions.remove(new EuclideanDistanceFunction());
                functions.remove(new SoundexSimilarityFunction());
            }
            if (Double.compare(avgNumTokens, 1.0) <= 0) {
                functions.remove(new Jaccard());
                functions.remove(new MongeElkanSimilarity());
            }
        }
        return functions;
    }
}

